/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.gui;

import edu.neu.ccs.Stringable;
import edu.neu.ccs.gui.CancelledException;
import edu.neu.ccs.gui.Display;
import edu.neu.ccs.gui.InputProperties;
import edu.neu.ccs.gui.JPTDialog;
import edu.neu.ccs.gui.SimpleAction;
import edu.neu.ccs.gui.TypedView;
import edu.neu.ccs.gui.WindowActionAdapter;
import edu.neu.ccs.util.JPTConstants;
import java.awt.Component;
import java.awt.Frame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public class InputDialog
extends JPTDialog
implements JPTConstants {
    protected Stringable model = null;
    protected boolean cancelled = false;

    public InputDialog(TypedView typedView) {
        super(InputDialog.getCompoundView(typedView), (String)null, (Frame)null, true);
        this.setResizable(false);
        JPanel jPanel = (JPanel)this.getContentPane();
        jPanel.setBorder(new EmptyBorder(20, 20, 20, 20));
        InputProperties inputProperties = this.view.getInputProperties();
        this.setTitle((String)inputProperties.getProperty("dialog.title"));
        this.setDefaultCloseOperation(0);
        this.createWindowListener(inputProperties);
        this.createActionsPanel(inputProperties);
        this.pack();
        this.center();
    }

    public Stringable getModel() {
        return this.model;
    }

    public boolean wasCancelled() {
        return this.cancelled;
    }

    public static Stringable showDemandDialog(TypedView typedView) {
        InputDialog inputDialog = InputDialog.showInputDialog(typedView, 0);
        return inputDialog.getModel();
    }

    public static Stringable showRequestDialog(TypedView typedView) throws CancelledException {
        InputDialog inputDialog = InputDialog.showInputDialog(typedView, 1);
        if (inputDialog.wasCancelled()) {
            throw new CancelledException();
        }
        return inputDialog.getModel();
    }

    protected void ok() {
        InputProperties inputProperties = this.view.getInputProperties();
        int n = (Integer)inputProperties.getProperty("input.model");
        if (n == 0) {
            this.demand();
        } else {
            this.request();
        }
    }

    protected void demand() {
        this.model = this.view.demandObject();
        ((Component)this).setVisible(false);
        this.dispose();
    }

    protected void request() {
        try {
            this.model = this.view.requestObject();
            ((Component)this).setVisible(false);
            this.dispose();
        }
        catch (CancelledException cancelledException) {
            this.model = null;
        }
    }

    protected void reset() {
        this.view.reset();
    }

    protected void suggest() {
        InputProperties inputProperties = this.view.getInputProperties();
        String string = (String)inputProperties.getProperty("suggestion");
        if (string == null) {
            string = "";
        }
        this.view.setViewState(string);
    }

    protected void cancel() {
        this.cancelled = true;
        ((Component)this).setVisible(false);
        this.dispose();
    }

    protected void refuse() {
        JOptionPane.showMessageDialog(this, "You must provide a valid value and press OK", "Input required", 0);
    }

    protected void createWindowListener(InputProperties inputProperties) {
        int n = (Integer)inputProperties.getProperty("input.model");
        WindowActionAdapter windowActionAdapter = new WindowActionAdapter(this);
        if (n == 0) {
            windowActionAdapter.addWindowClosingAction(new 1());
        } else {
            windowActionAdapter.addWindowClosingAction(new 2());
        }
    }

    protected void createActionsPanel(InputProperties inputProperties) {
        int n = (Integer)inputProperties.getProperty("input.model");
        String string = (String)inputProperties.getProperty("suggestion");
        this.addDefaultAction(new 3("OK"));
        this.addAction(new 4("Reset"));
        if (string != null) {
            this.addAction(new 5("Suggest"));
        }
        if (n == 1) {
            this.addAction(new 6("Cancel"));
        }
    }

    protected static TypedView getCompoundView(TypedView typedView) {
        return new CompoundView(typedView);
    }

    private static InputDialog showInputDialog(TypedView typedView, int n) {
        InputProperties inputProperties = InputDialog.setInputModel(typedView, n);
        InputDialog inputDialog = new InputDialog(typedView);
        ((Component)inputDialog).setVisible(true);
        typedView.setInputProperties(inputProperties);
        return inputDialog;
    }

    private static InputProperties setInputModel(TypedView typedView, int n) {
        InputProperties inputProperties = typedView.getInputProperties();
        InputProperties inputProperties2 = new InputProperties(inputProperties);
        inputProperties2.setProperty("input.model", new Integer(n));
        typedView.setInputProperties(inputProperties2);
        return inputProperties;
    }

    private final class 1
    extends SimpleAction {
        public void perform() {
            InputDialog.this.refuse();
        }

        /* synthetic */ 1() {
        }
    }

    private final class 2
    extends SimpleAction {
        public void perform() {
            InputDialog.this.cancel();
        }

        /* synthetic */ 2() {
        }
    }

    private final class 3
    extends SimpleAction {
        public void perform() {
            InputDialog.this.ok();
        }

        /* synthetic */ 3(String string) {
            super(string);
        }
    }

    private final class 4
    extends SimpleAction {
        public void perform() {
            InputDialog.this.reset();
        }

        /* synthetic */ 4(String string) {
            super(string);
        }
    }

    private final class 5
    extends SimpleAction {
        public void perform() {
            InputDialog.this.suggest();
        }

        /* synthetic */ 5(String string) {
            super(string);
        }
    }

    private final class 6
    extends SimpleAction {
        public void perform() {
            InputDialog.this.cancel();
        }

        /* synthetic */ 6(String string) {
            super(string);
        }
    }

    static class CompoundView
    extends Display
    implements TypedView {
        private TypedView view = null;

        public CompoundView(TypedView typedView) {
            super(typedView, (String)typedView.getInputProperties().getProperty("input.prompt"), null, 1, -1);
            this.view = typedView;
        }

        public Stringable demandObject() {
            return this.view.demandObject();
        }

        public Stringable requestObject() throws CancelledException {
            return this.view.requestObject();
        }

        public void setInputProperties(InputProperties inputProperties) {
            this.view.setInputProperties(inputProperties);
        }

        public InputProperties getInputProperties() {
            return this.view.getInputProperties();
        }

        public Class getDataType() {
            return this.view.getDataType();
        }
    }
}

