/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.gui;

import edu.neu.ccs.gui.AbstractPaintable;
import edu.neu.ccs.gui.TransformFactory;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JPanel;

public class ImagePaintableLite
extends AbstractPaintable {
    public static final String SET_IMAGE = "set.image";
    public static final String SET_TOP_LEFT_CORNER = "set.top.left.corner";
    private String imageFileName = null;
    private URL imageURL = null;
    private double xCorner = 0.0;
    private double yCorner = 0.0;
    private int width = 0;
    private int height = 0;

    public ImagePaintableLite() {
    }

    public ImagePaintableLite(String string) {
        this.setImageByFileName(string);
    }

    public ImagePaintableLite(String string, Point2D point2D) {
        this.setImageByFileName(string);
        this.setTopLeftCorner(point2D);
    }

    public ImagePaintableLite(String string, double d, double d2) {
        this.setImageByFileName(string);
        this.setTopLeftCorner(d, d2);
    }

    public ImagePaintableLite(URL uRL) {
        this.setImageByURL(uRL);
    }

    public ImagePaintableLite(URL uRL, Point2D point2D) {
        this.setImageByURL(uRL);
        this.setTopLeftCorner(point2D);
    }

    public ImagePaintableLite(URL uRL, double d, double d2) {
        this.setImageByURL(uRL);
        this.setTopLeftCorner(d, d2);
    }

    public final void paint(Graphics graphics) {
        if (graphics == null || !this.isVisible()) {
            return;
        }
        Image image = this.fetchImage();
        if (image == null) {
            return;
        }
        Graphics2D graphics2D = this.getPreparedGraphics2D(graphics);
        AffineTransform affineTransform = TransformFactory.translate(this.xCorner, this.yCorner);
        graphics2D.drawImage(image, affineTransform, null);
    }

    public final Rectangle2D getBounds2D() {
        Rectangle2D rectangle2D = this.getDefaultBounds2D();
        if (rectangle2D != null) {
            return rectangle2D;
        }
        return new Rectangle2D.Double(this.xCorner, this.yCorner, this.width, this.height);
    }

    public final Point2D getCenter() {
        Point2D point2D = this.getDefaultCenter();
        if (point2D != null) {
            return point2D;
        }
        return super.getCenter();
    }

    public final boolean contains(double d, double d2) {
        return this.possiblyContains(d, d2);
    }

    public final void setImageByFileName(String string) {
        this.imageURL = null;
        this.imageFileName = string;
        this.setImageSizeParameters();
    }

    public final void setImageByURL(URL uRL) {
        this.imageFileName = null;
        this.imageURL = uRL;
        this.setImageSizeParameters();
    }

    public final void setTopLeftCorner(Point2D point2D) {
        if (point2D == null) {
            return;
        }
        this.setTopLeftCorner(point2D.getX(), point2D.getY());
    }

    public final void setTopLeftCorner(double d, double d2) {
        if (d != this.xCorner || d2 != this.yCorner) {
            this.xCorner = d;
            this.yCorner = d2;
            this.firePropertyChange(SET_TOP_LEFT_CORNER, null, null);
        }
    }

    public final Point2D getTopLeftCorner() {
        return new Point2D.Double(this.xCorner, this.yCorner);
    }

    public final int getImageWidth() {
        return this.width;
    }

    public final int getImageHeight() {
        return this.height;
    }

    private final ImageIcon fetchImageIcon() {
        if (this.imageFileName != null) {
            return new ImageIcon(this.imageFileName);
        }
        if (this.imageURL != null) {
            return new ImageIcon(this.imageURL);
        }
        return null;
    }

    private final Image fetchImage() {
        ImageIcon imageIcon = this.fetchImageIcon();
        if (imageIcon == null) {
            return null;
        }
        return imageIcon.getImage();
    }

    private final void setImageSizeParameters() {
        Image image = this.fetchImage();
        if (image == null) {
            this.width = 0;
            this.height = 0;
        } else {
            JPanel jPanel = new JPanel();
            this.width = image.getWidth(jPanel);
            this.height = image.getHeight(jPanel);
        }
        this.firePropertyChange(SET_IMAGE, null, null);
    }
}

