/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.gui;

import edu.neu.ccs.gui.Displayable;
import edu.neu.ccs.gui.Refresh;
import edu.neu.ccs.gui.TextFieldView;
import edu.neu.ccs.util.JPTConstants;
import java.awt.Dimension;
import java.awt.Font;
import java.util.Vector;
import javax.swing.JComboBox;

public class Dropdown
extends JComboBox
implements Displayable,
JPTConstants {
    public static final String PREFERRED_WIDTH = "set.preferred.width";
    public static final int DEFAULT_WIDTH = 125;
    protected static final String DEFAULT_SELECTION = "";
    protected int preferredWidth = 125;
    protected int minimumWidth = 0;
    protected Vector itemList = null;
    protected String defaultViewState = "";

    public Dropdown() {
        this.initializeDropdown(null, DEFAULT_SELECTION, null, 0, false);
    }

    public Dropdown(int n) {
        this.initializeDropdown(null, DEFAULT_SELECTION, null, n, false);
    }

    public Dropdown(Font font) {
        this.initializeDropdown(null, DEFAULT_SELECTION, font, 0, false);
    }

    public Dropdown(Font font, int n) {
        this.initializeDropdown(null, DEFAULT_SELECTION, font, n, false);
    }

    public Dropdown(String[] stringArray) {
        this.initializeDropdown(stringArray, DEFAULT_SELECTION, null, 0, false);
    }

    public Dropdown(String[] stringArray, int n) {
        this.initializeDropdown(stringArray, DEFAULT_SELECTION, null, n, false);
    }

    public Dropdown(String[] stringArray, Font font) {
        this.initializeDropdown(stringArray, DEFAULT_SELECTION, font, 0, false);
    }

    public Dropdown(String[] stringArray, Font font, int n) {
        this.initializeDropdown(stringArray, DEFAULT_SELECTION, font, n, false);
    }

    public Dropdown(String[] stringArray, String string) {
        this.initializeDropdown(stringArray, string, null, 0, false);
    }

    public Dropdown(String[] stringArray, String string, int n) {
        this.initializeDropdown(stringArray, string, null, n, false);
    }

    public Dropdown(String[] stringArray, String string, Font font) {
        this.initializeDropdown(stringArray, string, font, 0, false);
    }

    public Dropdown(String[] stringArray, String string, Font font, int n) {
        this.initializeDropdown(stringArray, string, font, n, false);
    }

    public Dropdown(String[] stringArray, String string, boolean bl) {
        this.initializeDropdown(stringArray, string, null, 0, bl);
    }

    public Dropdown(String[] stringArray, String string, int n, boolean bl) {
        this.initializeDropdown(stringArray, string, null, n, bl);
    }

    public Dropdown(String[] stringArray, String string, Font font, boolean bl) {
        this.initializeDropdown(stringArray, string, font, 0, bl);
    }

    public Dropdown(String[] stringArray, String string, Font font, int n, boolean bl) {
        this.initializeDropdown(stringArray, string, font, n, bl);
    }

    protected void initializeDropdown(String[] stringArray, String string, Font font, int n, boolean bl) {
        this.itemList = new Vector();
        this.setEditable(bl);
        if (font != null) {
            super.setFont(font);
        }
        if (stringArray != null) {
            int n2 = stringArray.length;
            int n3 = 0;
            while (n3 < n2) {
                this.addItem(stringArray[n3]);
                ++n3;
            }
        }
        this.setMinimumWidth(n);
        this.autoSetPreferredWidth();
        this.setViewState(string);
        this.setDefaultViewState(string);
    }

    public void addItem(Object object) {
        if (object == null) {
            return;
        }
        if (!(object instanceof String)) {
            return;
        }
        this.itemList.add(object);
        super.addItem(object);
    }

    public void insertItemAt(Object object, int n) {
        if (object == null) {
            return;
        }
        if (!(object instanceof String)) {
            return;
        }
        this.itemList.add(n, object);
        super.insertItemAt(object, n);
    }

    public void removeItem(Object object) {
        if (object == null) {
            return;
        }
        if (!(object instanceof String)) {
            return;
        }
        this.itemList.remove(object);
        super.removeItem(object);
    }

    public void removeItemAt(int n) {
        this.itemList.remove(n);
        super.removeItemAt(n);
    }

    public void removeAllItems() {
        super.removeAllItems();
        this.itemList.clear();
    }

    public void addItems(String[] stringArray) {
        if (stringArray == null) {
            return;
        }
        int n = 0;
        while (n < stringArray.length) {
            this.addItem(stringArray[n]);
            ++n;
        }
        this.refresh();
    }

    public void setItems(String[] stringArray) {
        this.removeAllItems();
        this.addItems(stringArray);
    }

    public void removeItems(String[] stringArray) {
        if (stringArray == null) {
            return;
        }
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n] != null) {
                this.removeItem(stringArray[n]);
            }
            ++n;
        }
    }

    public String[] getItems() {
        String[] stringArray = new String[]{};
        if (this.itemList == null || this.itemList.size() == 0) {
            return stringArray;
        }
        return this.itemList.toArray(stringArray);
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        int n = this.getPreferredWidth();
        if (n > 0) {
            dimension.width = n + dimension.height;
        }
        return dimension;
    }

    public int getPreferredWidth() {
        return this.preferredWidth;
    }

    public void autoSetPreferredWidth() {
        int n = this.getMinimumWidth();
        int n2 = TextFieldView.getWidthEstimate(this.getFont(), this.getItems());
        this.setPreferredWidth(n, n2);
    }

    public void setMinimumWidth(int n) {
        this.minimumWidth = n;
    }

    public int getMinimumWidth() {
        return this.minimumWidth;
    }

    public void setPreferredWidth(int n) {
        int n2 = this.getPreferredWidth();
        this.preferredWidth = n < 0 ? -1 : (n == 0 ? 125 : n);
        this.refreshComponent();
        this.firePropertyChange(PREFERRED_WIDTH, n2, this.preferredWidth);
    }

    public void setPreferredWidth(int n, String string) {
        int n2 = TextFieldView.getSampleWidth(this.getFont(), string);
        this.setPreferredWidth(n, n2);
    }

    public void setPreferredWidth(int n, int n2) {
        this.setMinimumWidth(n);
        if (n2 <= 0) {
            this.setPreferredWidth(n);
        } else {
            if (n == 0) {
                n = 125;
            }
            this.setPreferredWidth(Math.max(n, n2));
        }
    }

    public void setFont(Font font) {
        if (this.itemList == null) {
            super.setFont(font);
            return;
        }
        if (font == null) {
            font = Dropdown.getDefaultFont();
        }
        String string = this.getDefaultViewState();
        String[] stringArray = this.getItems();
        String string2 = this.getViewState();
        int n = this.getMinimumWidth();
        boolean bl = this.isEditable();
        this.removeAllItems();
        this.initializeDropdown(stringArray, string2, font, n, bl);
        this.setDefaultViewState(string);
        this.firePropertyChange("set.font", null, null);
    }

    public static Font getDefaultFont() {
        return new JComboBox().getFont();
    }

    public void setViewState(String string) {
        if (string == null) {
            return;
        }
        String string2 = this.getViewState();
        if (string.equals(string2)) {
            return;
        }
        boolean bl = false;
        int n = 0;
        while (n < this.getItemCount()) {
            String string3 = this.getItemAt(n).toString();
            if (string3 != null && string3.equals(string)) {
                this.setSelectedIndex(n);
                bl = true;
                break;
            }
            ++n;
        }
        if (!bl && this.isEditable()) {
            this.setSelectedItem(string);
            bl = true;
        }
        if (bl) {
            this.firePropertyChange("view.state", string2, string);
        }
    }

    public String getViewState() {
        return (String)this.getSelectedItem();
    }

    public void setDefaultViewState(String string) {
        String string2 = this.defaultViewState;
        this.defaultViewState = string = string == null ? DEFAULT_SELECTION : string;
        if (!string2.equals(this.defaultViewState)) {
            this.firePropertyChange("default.view.state", 0, 1);
        }
    }

    public String getDefaultViewState() {
        return this.defaultViewState;
    }

    public void reset() {
        this.setViewState(this.getDefaultViewState());
    }

    public void refresh() {
        this.autoSetPreferredWidth();
        this.refreshComponent();
    }

    public void refreshComponent() {
        Refresh.packParentWindow(this);
    }
}

