/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.gui;

import edu.neu.ccs.gui.ClosureMode;
import edu.neu.ccs.gui.Path;
import edu.neu.ccs.gui.PropertyChangeForwardingListener;
import edu.neu.ccs.gui.SupportsPropertyChange;
import edu.neu.ccs.gui.TweakableShape;
import edu.neu.ccs.gui.WindingRule;
import edu.neu.ccs.util.FloatArray;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;

public class BaseShape
implements Shape,
SupportsPropertyChange {
    public static final String SET_PATH_STRATEGY = "set.path.strategy";
    public static final String SET_CLOSURE_MODE = "set.closure.mode";
    public static final String SET_WINDING_RULE = "set.winding.rule";
    public static final String REMOVE_SHAPE_DATA = "remove.shape.data";
    protected float[][] vertex = new float[0][2];
    protected float[][] tangent = new float[0][2];
    private GeneralPath path = new GeneralPath(1);
    private Path.Strategy pathstrategy = Path.POLYGON;
    private ClosureMode closuremode = ClosureMode.CLOSED;
    private WindingRule windingrule = WindingRule.WIND_NON_ZERO;
    private final PropertyChangeSupport changeAdapter = new PropertyChangeSupport(this);
    private final PropertyChangeForwardingListener forwardingListener = new PropertyChangeForwardingListener(this);

    protected BaseShape() {
    }

    public final TweakableShape makePolygonDots() {
        return new TweakableShape(this.getVertexData(), null, Path.POLYGON_DOTS, ClosureMode.OPEN, this.getWindingRule());
    }

    public final TweakableShape makeClosedBezierFrame() {
        return new TweakableShape(this.getClosedBezierFrameData(), null, Path.POLYGON, ClosureMode.CLOSED, this.getWindingRule());
    }

    public final TweakableShape makeOpenBezierFrame() {
        return new TweakableShape(this.getOpenBezierFrameData(), null, Path.POLYGON, ClosureMode.OPEN, this.getWindingRule());
    }

    public final TweakableShape makeBezierTangentSegments() {
        return new TweakableShape(this.getVertexData(), this.getTangentData(), Path.BEZIER_TANGENT_SEGMENTS, ClosureMode.OPEN, this.getWindingRule());
    }

    public final int length() {
        return this.vertex.length;
    }

    public final float[][] getVertexData() {
        return FloatArray.deepclone(this.vertex);
    }

    public final float[][] getTangentData() {
        return FloatArray.deepclone(this.tangent);
    }

    public final float[] getPolygonPoint(float f) {
        int n = this.vertex.length;
        if (n == 0) {
            return new float[2];
        }
        if (n == 1 || f <= 0.0f || f >= (float)n) {
            return FloatArray.deepclone(this.vertex[0]);
        }
        int n2 = (int)f;
        int n3 = (n2 + 1) % n;
        float f2 = f - (float)n2;
        if (f2 == 0.0f) {
            return FloatArray.deepclone(this.vertex[n2]);
        }
        float f3 = 1.0f - f2;
        return new float[]{f3 * this.vertex[n2][0] + f2 * this.vertex[n3][0], f3 * this.vertex[n2][1] + f2 * this.vertex[n3][1]};
    }

    public final float[] getCubicCurvePoint(float f) {
        int n = this.vertex.length;
        if (n == 0) {
            return new float[2];
        }
        if (n == 1 || f <= 0.0f || f >= (float)n) {
            return FloatArray.deepclone(this.vertex[0]);
        }
        int n2 = (int)f;
        int n3 = (n2 + 1) % n;
        float f2 = f - (float)n2;
        if (f2 == 0.0f) {
            return FloatArray.deepclone(this.vertex[n2]);
        }
        float f3 = 1.0f - f2;
        float f4 = f3 * f3 * f3;
        float f5 = 3.0f * f3 * f3 * f2;
        float f6 = 3.0f * f3 * f2 * f2;
        float f7 = f2 * f2 * f2;
        return new float[]{f4 * this.vertex[n2][0] + f5 * (this.vertex[n2][0] + this.tangent[n2][0]) + f6 * (this.vertex[n3][0] - this.tangent[n3][0]) + f7 * this.vertex[n3][0], f4 * this.vertex[n2][1] + f5 * (this.vertex[n2][1] + this.tangent[n2][1]) + f6 * (this.vertex[n3][1] - this.tangent[n3][1]) + f7 * this.vertex[n3][1]};
    }

    public final float[][] getClosedBezierFrameData() {
        return Path.closedBezierFrame(this.vertex, this.tangent);
    }

    public final float[][] getOpenBezierFrameData() {
        return Path.openBezierFrame(this.vertex, this.tangent);
    }

    public final float[][] getBezierTangentSegmentData() {
        return Path.bezierTangentSegments(this.vertex, this.tangent);
    }

    public final float[][] getMergedVertexTangentData() {
        return FloatArray.deepmerge(this.vertex, this.tangent);
    }

    public final void removeShapeData() {
        this.vertex = new float[0][2];
        this.tangent = new float[0][2];
        this.makePath();
        this.firePropertyChange(REMOVE_SHAPE_DATA, null, null);
    }

    public final void setPathStrategy(Path.Strategy strategy) {
        if (strategy == null || strategy == this.pathstrategy) {
            return;
        }
        this.pathstrategy = strategy;
        this.makePath();
        this.firePropertyChange(SET_PATH_STRATEGY, null, null);
    }

    public final Path.Strategy getPathStrategy() {
        return this.pathstrategy;
    }

    public final void setClosureMode(ClosureMode closureMode) {
        if (closureMode == null || closureMode == this.closuremode) {
            return;
        }
        this.closuremode = closureMode;
        this.makePath();
        this.firePropertyChange(SET_CLOSURE_MODE, null, null);
    }

    public final ClosureMode getClosureMode() {
        return this.closuremode;
    }

    public final void setWindingRule(WindingRule windingRule) {
        if (windingRule == null || windingRule == this.windingrule) {
            return;
        }
        this.windingrule = windingRule;
        this.makePath();
        this.firePropertyChange(SET_WINDING_RULE, null, null);
    }

    public final WindingRule getWindingRule() {
        return this.windingrule;
    }

    public final GeneralPath getPath() {
        return this.pathstrategy.makePath(this.vertex, this.tangent, this.closuremode, this.windingrule);
    }

    protected final void makePath() {
        this.path = this.getPath();
    }

    public final boolean contains(double d, double d2) {
        return this.path.contains(d, d2);
    }

    public final boolean contains(Point2D point2D) {
        return this.path.contains(point2D);
    }

    public final boolean contains(double d, double d2, double d3, double d4) {
        return this.path.contains(d, d2, d3, d4);
    }

    public final boolean contains(Rectangle2D rectangle2D) {
        return this.path.contains(rectangle2D);
    }

    public final boolean intersects(double d, double d2, double d3, double d4) {
        return this.path.intersects(d, d2, d3, d4);
    }

    public final boolean intersects(Rectangle2D rectangle2D) {
        return this.path.intersects(rectangle2D);
    }

    public final Rectangle getBounds() {
        return this.path.getBounds();
    }

    public final Rectangle2D getBounds2D() {
        return this.path.getBounds2D();
    }

    public final PathIterator getPathIterator(AffineTransform affineTransform) {
        return this.path.getPathIterator(affineTransform);
    }

    public final PathIterator getPathIterator(AffineTransform affineTransform, double d) {
        return this.path.getPathIterator(affineTransform, d);
    }

    public final void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changeAdapter.addPropertyChangeListener(propertyChangeListener);
    }

    public final void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.changeAdapter.addPropertyChangeListener(string, propertyChangeListener);
    }

    public void addPropertyChangeListeners(PropertyChangeListener[] propertyChangeListenerArray) {
        if (propertyChangeListenerArray == null) {
            return;
        }
        int n = propertyChangeListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            this.addPropertyChangeListener(propertyChangeListenerArray[n2]);
            ++n2;
        }
    }

    public void addPropertyChangeListeners(String string, PropertyChangeListener[] propertyChangeListenerArray) {
        if (propertyChangeListenerArray == null) {
            return;
        }
        int n = propertyChangeListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            this.addPropertyChangeListener(string, propertyChangeListenerArray[n2]);
            ++n2;
        }
    }

    public final void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changeAdapter.removePropertyChangeListener(propertyChangeListener);
    }

    public final void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.changeAdapter.removePropertyChangeListener(string, propertyChangeListener);
    }

    public final PropertyChangeListener[] getPropertyChangeListeners() {
        return this.changeAdapter.getPropertyChangeListeners();
    }

    public final PropertyChangeListener[] getPropertyChangeListeners(String string) {
        return this.changeAdapter.getPropertyChangeListeners(string);
    }

    public final boolean hasListeners(String string) {
        return this.changeAdapter.hasListeners(string);
    }

    public final void firePropertyChange(String string, Object object, Object object2) {
        this.changeAdapter.firePropertyChange(string, object, object2);
    }

    public final void firePropertyChange(String string, boolean bl, boolean bl2) {
        if (bl2 != bl) {
            this.changeAdapter.firePropertyChange(string, bl, bl2);
        }
    }

    public final void firePropertyChange(String string, char c, char c2) {
        if (c2 != c) {
            this.changeAdapter.firePropertyChange(string, new Character(c), new Character(c2));
        }
    }

    public final void firePropertyChange(String string, byte by, byte by2) {
        if (by2 != by) {
            this.changeAdapter.firePropertyChange(string, new Byte(by), new Byte(by2));
        }
    }

    public final void firePropertyChange(String string, short s, short s2) {
        if (s2 != s) {
            this.changeAdapter.firePropertyChange(string, new Short(s), new Short(s2));
        }
    }

    public final void firePropertyChange(String string, int n, int n2) {
        if (n2 != n) {
            this.changeAdapter.firePropertyChange(string, n, n2);
        }
    }

    public final void firePropertyChange(String string, long l, long l2) {
        if (l2 != l) {
            this.changeAdapter.firePropertyChange(string, new Long(l), new Long(l2));
        }
    }

    public final void firePropertyChange(String string, float f, float f2) {
        if (f2 != f) {
            this.changeAdapter.firePropertyChange(string, new Float(f), new Float(f2));
        }
    }

    public final void firePropertyChange(String string, double d, double d2) {
        if (d2 != d) {
            this.changeAdapter.firePropertyChange(string, new Double(d), new Double(d2));
        }
    }

    public final void firePropertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.changeAdapter.firePropertyChange(propertyChangeEvent);
    }

    public final PropertyChangeForwardingListener getForwardingListener() {
        return this.forwardingListener;
    }

    public final void addForwardingListener(Object object) {
        if (object instanceof SupportsPropertyChange) {
            SupportsPropertyChange supportsPropertyChange = (SupportsPropertyChange)object;
            supportsPropertyChange.addPropertyChangeListener(this.getForwardingListener());
        }
    }

    public final void removeForwardingListener(Object object) {
        if (object instanceof SupportsPropertyChange) {
            SupportsPropertyChange supportsPropertyChange = (SupportsPropertyChange)object;
            supportsPropertyChange.removePropertyChangeListener(this.getForwardingListener());
        }
    }

    public final void removeAndAddForwardingListener(Object object, Object object2) {
        this.removeForwardingListener(object);
        this.addForwardingListener(object2);
    }
}

