/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.gui;

import edu.neu.ccs.gui.BaseShape;
import edu.neu.ccs.gui.ClosureMode;
import edu.neu.ccs.gui.Path;
import edu.neu.ccs.gui.Tangent;
import edu.neu.ccs.gui.WindingRule;
import edu.neu.ccs.util.FloatArray;

public class AutomaticShape
extends BaseShape {
    public static final String SET_VERTEX_DATA = "set.vertex.data";
    public static final String SET_VERTEX = "set.vertex";
    public static final String ADD_VERTEX = "add.vertex";
    public static final String REMOVE_VERTEX = "remove.vertex";
    public static final String SET_TANGENT_STRATEGY = "set.tangent.strategy";
    public static final String SET_END_TANGENT_DATA = "set.end.tangent.data";
    public static final String SET_END_TANGENT = "set.end.tangent";
    private Tangent.Strategy tangentstrategy = Tangent.bezierStrategy();
    private float[][] endTangent = null;

    public AutomaticShape() {
        this(null, null, null, null, null, null);
    }

    public AutomaticShape(float[][] fArray) {
        this(fArray, null, null, null, null, null);
    }

    public AutomaticShape(float[][] fArray, float[][] fArray2) {
        this(fArray, fArray2, null, null, null, null);
    }

    public AutomaticShape(float[][] fArray, float[][] fArray2, Tangent.Strategy strategy) {
        this(fArray, fArray2, strategy, null, null, null);
    }

    public AutomaticShape(float[][] fArray, float[][] fArray2, Tangent.Strategy strategy, Path.Strategy strategy2) {
        this(fArray, fArray2, strategy, strategy2, null, null);
    }

    public AutomaticShape(float[][] fArray, float[][] fArray2, Tangent.Strategy strategy, Path.Strategy strategy2, ClosureMode closureMode) {
        this(fArray, fArray2, strategy, strategy2, closureMode, null);
    }

    public AutomaticShape(float[][] fArray, float[][] fArray2, Tangent.Strategy strategy, Path.Strategy strategy2, ClosureMode closureMode, WindingRule windingRule) {
        this.setTangentStrategy(strategy);
        this.setPathStrategy(strategy2);
        this.setClosureMode(closureMode);
        this.setWindingRule(windingRule);
        this.setEndTangentData(fArray2);
        this.setVertexData(fArray);
    }

    public final void setVertexData(float[][] fArray) {
        if (!FloatArray.checkArray(fArray, 2)) {
            return;
        }
        if (FloatArray.equals(this.vertex, fArray)) {
            return;
        }
        this.vertex = FloatArray.deepclone(fArray);
        this.makeAutomaticPath();
        this.firePropertyChange(SET_VERTEX_DATA, null, null);
    }

    public final void setVertex(int n, float f, float f2) {
        if (n < 0 || n >= this.vertex.length) {
            return;
        }
        if (this.vertex[n][0] == f && this.vertex[n][1] == f2) {
            return;
        }
        this.vertex[n][0] = f;
        this.vertex[n][1] = f2;
        this.makeAutomaticPath();
        this.firePropertyChange(SET_VERTEX, null, null);
    }

    public final void setVertex(int n, float[] fArray) {
        if (fArray == null || fArray.length != 2) {
            return;
        }
        this.setVertex(n, fArray[0], fArray[1]);
    }

    public final void addVertex(int n, float f, float f2) {
        int n2 = this.vertex.length;
        int n3 = n2 + 1;
        if (n < 0 || n > n2) {
            return;
        }
        float[][] fArray = this.vertex;
        this.vertex = new float[n3][2];
        this.vertex[n][0] = f;
        this.vertex[n][1] = f2;
        int n4 = 0;
        while (n4 < n3) {
            if (n4 < n) {
                this.vertex[n4][0] = fArray[n4][0];
                this.vertex[n4][1] = fArray[n4][1];
            } else if (n4 > n) {
                int n5 = n4 - 1;
                this.vertex[n4][0] = fArray[n5][0];
                this.vertex[n4][1] = fArray[n5][1];
            }
            ++n4;
        }
        this.makeAutomaticPath();
        this.firePropertyChange(ADD_VERTEX, null, null);
    }

    public final void addVertex(int n, float[] fArray) {
        if (fArray == null || fArray.length != 2) {
            return;
        }
        this.addVertex(n, fArray[0], fArray[1]);
    }

    public final void removeVertex(int n) {
        int n2 = this.vertex.length;
        int n3 = n2 - 1;
        if (n < 0 || n >= n2) {
            return;
        }
        float[][] fArray = this.vertex;
        this.vertex = new float[n3][2];
        int n4 = 0;
        while (n4 < n2) {
            if (n4 < n) {
                this.vertex[n4][0] = fArray[n4][0];
                this.vertex[n4][1] = fArray[n4][1];
            } else if (n4 > n) {
                int n5 = n4 - 1;
                this.vertex[n5][0] = fArray[n4][0];
                this.vertex[n5][1] = fArray[n4][1];
            }
            ++n4;
        }
        this.makeAutomaticPath();
        this.firePropertyChange(REMOVE_VERTEX, null, null);
    }

    public final void setEndTangentData(float[][] fArray) {
        if (fArray == null) {
            if (this.endTangent == null) {
                return;
            }
            this.endTangent = null;
        } else {
            if (!FloatArray.checkArray(fArray, 2) || fArray.length != 2) {
                return;
            }
            if (FloatArray.equals(this.endTangent, fArray)) {
                return;
            }
            this.endTangent = FloatArray.deepclone(fArray);
        }
        this.makeAutomaticPath();
        this.firePropertyChange(SET_END_TANGENT_DATA, null, null);
    }

    public final float[][] getEndTangentData() {
        return FloatArray.deepclone(this.endTangent);
    }

    public final void setEndTangent(int n, float f, float f2) {
        if (n < 0 || n > 1) {
            return;
        }
        if (this.endTangent == null) {
            this.endTangent = new float[2][2];
        } else if (this.endTangent[n][0] == f && this.endTangent[n][1] == f2) {
            return;
        }
        this.endTangent[n][0] = f;
        this.endTangent[n][1] = f2;
        this.makeAutomaticPath();
        this.firePropertyChange(SET_END_TANGENT, null, null);
    }

    public final void setEndTangent(int n, float[] fArray) {
        if (fArray == null || fArray.length != 2) {
            return;
        }
        this.setEndTangent(n, fArray[0], fArray[1]);
    }

    public final void setTangentStrategy(Tangent.Strategy strategy) {
        if (strategy == null || strategy == this.tangentstrategy) {
            return;
        }
        this.tangentstrategy = strategy;
        this.makeAutomaticPath();
        this.firePropertyChange(SET_TANGENT_STRATEGY, null, null);
    }

    public final Tangent.Strategy getTangentStrategy() {
        return this.tangentstrategy;
    }

    protected final void makeAutomaticPath() {
        this.tangent = this.getClosureMode() == ClosureMode.CLOSED ? this.tangentstrategy.makeTangents(this.vertex) : this.tangentstrategy.makeTangents(this.vertex, this.endTangent);
        this.makePath();
    }
}

