/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.gui;

import edu.neu.ccs.gui.Paintable;
import edu.neu.ccs.gui.PropertyChangeForwardingListener;
import edu.neu.ccs.gui.SupportsPropertyChange;
import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;

public abstract class AbstractPaintable
implements Paintable,
SupportsPropertyChange {
    public static final String SET_DEFAULT_BOUNDS2D = "set.default.bounds2d";
    public static final String SET_DEFAULT_CENTER = "set.default.center";
    public static final String SET_VISIBLE = "set.visible";
    public static final String SET_OPACITY = "set.opacity";
    private Rectangle2D defaultBounds2D = null;
    private Point2D defaultCenter = null;
    private boolean visible = true;
    private float opacity = 1.0f;
    private final PropertyChangeSupport changeAdapter = new PropertyChangeSupport(this);
    private final PropertyChangeForwardingListener forwardingListener = new PropertyChangeForwardingListener(this);

    public abstract void paint(Graphics var1);

    public abstract Rectangle2D getBounds2D();

    public Point2D getCenter() {
        Rectangle2D rectangle2D = this.getBounds2D();
        double d = rectangle2D.getCenterX();
        double d2 = rectangle2D.getCenterY();
        return new Point2D.Double(d, d2);
    }

    public final void setDefaultBounds2D(Rectangle2D rectangle2D) {
        if (rectangle2D == null) {
            if (this.defaultBounds2D == null) {
                return;
            }
            this.defaultBounds2D = null;
        } else {
            if (rectangle2D.equals(this.defaultBounds2D)) {
                return;
            }
            double d = rectangle2D.getX();
            double d2 = rectangle2D.getY();
            double d3 = rectangle2D.getWidth();
            double d4 = rectangle2D.getHeight();
            this.defaultBounds2D = d3 <= 0.0 || d4 <= 0.0 ? null : new Rectangle2D.Double(d, d2, d3, d4);
        }
        this.firePropertyChange(SET_DEFAULT_BOUNDS2D, null, null);
    }

    public final Rectangle2D getDefaultBounds2D() {
        if (this.defaultBounds2D == null) {
            return null;
        }
        double d = this.defaultBounds2D.getX();
        double d2 = this.defaultBounds2D.getY();
        double d3 = this.defaultBounds2D.getWidth();
        double d4 = this.defaultBounds2D.getHeight();
        return new Rectangle2D.Double(d, d2, d3, d4);
    }

    public final void setDefaultCenter(Point2D point2D) {
        if (point2D == null) {
            if (this.defaultCenter == null) {
                return;
            }
            this.defaultCenter = null;
        } else {
            if (point2D.equals(this.defaultCenter)) {
                return;
            }
            double d = point2D.getX();
            double d2 = point2D.getY();
            this.defaultCenter = new Point2D.Double(d, d2);
        }
        this.firePropertyChange(SET_DEFAULT_CENTER, null, null);
    }

    public final Point2D getDefaultCenter() {
        if (this.defaultCenter == null) {
            return null;
        }
        double d = this.defaultCenter.getX();
        double d2 = this.defaultCenter.getY();
        return new Point2D.Double(d, d2);
    }

    public final boolean contains(Point2D point2D) {
        if (point2D == null) {
            return false;
        }
        return this.contains(point2D.getX(), point2D.getY());
    }

    protected final boolean possiblyContains(double d, double d2) {
        return this.isVisible() && this.getBounds2D().contains(d, d2);
    }

    public final void setVisible(boolean bl) {
        if (this.visible != bl) {
            this.visible = bl;
            this.firePropertyChange(SET_VISIBLE, null, null);
        }
    }

    public final boolean isVisible() {
        return this.visible;
    }

    public final void setOpacity(float f) {
        if (f < 0.0f) {
            f = 0.0f;
        }
        if (f > 1.0f) {
            f = 1.0f;
        }
        if (this.opacity != f) {
            this.opacity = f;
            this.firePropertyChange(SET_OPACITY, null, null);
        }
    }

    public final float getOpacity() {
        return this.opacity;
    }

    public final void applyOpacity(Graphics2D graphics2D) {
        if (this.opacity >= 1.0f) {
            return;
        }
        Composite composite = graphics2D.getComposite();
        float f = this.opacity;
        if (composite instanceof AlphaComposite) {
            AlphaComposite alphaComposite = (AlphaComposite)composite;
            if (alphaComposite.getRule() != 3) {
                return;
            }
            f *= alphaComposite.getAlpha();
        } else if (composite != null) {
            return;
        }
        graphics2D.setComposite(AlphaComposite.getInstance(3, f));
    }

    public final Graphics2D getPreparedGraphics2D(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.clip(this.getBounds2D());
        this.applyOpacity(graphics2D);
        return graphics2D;
    }

    public final void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changeAdapter.addPropertyChangeListener(propertyChangeListener);
    }

    public final void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.changeAdapter.addPropertyChangeListener(string, propertyChangeListener);
    }

    public final void addPropertyChangeListeners(PropertyChangeListener[] propertyChangeListenerArray) {
        if (propertyChangeListenerArray == null) {
            return;
        }
        int n = propertyChangeListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            this.addPropertyChangeListener(propertyChangeListenerArray[n2]);
            ++n2;
        }
    }

    public final void addPropertyChangeListeners(String string, PropertyChangeListener[] propertyChangeListenerArray) {
        if (propertyChangeListenerArray == null) {
            return;
        }
        int n = propertyChangeListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            this.addPropertyChangeListener(string, propertyChangeListenerArray[n2]);
            ++n2;
        }
    }

    public final void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changeAdapter.removePropertyChangeListener(propertyChangeListener);
    }

    public final void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.changeAdapter.removePropertyChangeListener(string, propertyChangeListener);
    }

    public final PropertyChangeListener[] getPropertyChangeListeners() {
        return this.changeAdapter.getPropertyChangeListeners();
    }

    public final PropertyChangeListener[] getPropertyChangeListeners(String string) {
        return this.changeAdapter.getPropertyChangeListeners(string);
    }

    public final boolean hasListeners(String string) {
        return this.changeAdapter.hasListeners(string);
    }

    public final void firePropertyChange(String string, Object object, Object object2) {
        this.changeAdapter.firePropertyChange(string, object, object2);
    }

    public final void firePropertyChange(String string, boolean bl, boolean bl2) {
        if (bl2 != bl) {
            this.changeAdapter.firePropertyChange(string, bl, bl2);
        }
    }

    public final void firePropertyChange(String string, char c, char c2) {
        if (c2 != c) {
            this.changeAdapter.firePropertyChange(string, new Character(c), new Character(c2));
        }
    }

    public final void firePropertyChange(String string, byte by, byte by2) {
        if (by2 != by) {
            this.changeAdapter.firePropertyChange(string, new Byte(by), new Byte(by2));
        }
    }

    public final void firePropertyChange(String string, short s, short s2) {
        if (s2 != s) {
            this.changeAdapter.firePropertyChange(string, new Short(s), new Short(s2));
        }
    }

    public final void firePropertyChange(String string, int n, int n2) {
        if (n2 != n) {
            this.changeAdapter.firePropertyChange(string, n, n2);
        }
    }

    public final void firePropertyChange(String string, long l, long l2) {
        if (l2 != l) {
            this.changeAdapter.firePropertyChange(string, new Long(l), new Long(l2));
        }
    }

    public final void firePropertyChange(String string, float f, float f2) {
        if (f2 != f) {
            this.changeAdapter.firePropertyChange(string, new Float(f), new Float(f2));
        }
    }

    public final void firePropertyChange(String string, double d, double d2) {
        if (d2 != d) {
            this.changeAdapter.firePropertyChange(string, new Double(d), new Double(d2));
        }
    }

    public final void firePropertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.changeAdapter.firePropertyChange(propertyChangeEvent);
    }

    public final PropertyChangeForwardingListener getForwardingListener() {
        return this.forwardingListener;
    }

    public final void addForwardingListener(Object object) {
        if (object instanceof SupportsPropertyChange) {
            SupportsPropertyChange supportsPropertyChange = (SupportsPropertyChange)object;
            supportsPropertyChange.addPropertyChangeListener(this.getForwardingListener());
        }
    }

    public final void removeForwardingListener(Object object) {
        if (object instanceof SupportsPropertyChange) {
            SupportsPropertyChange supportsPropertyChange = (SupportsPropertyChange)object;
            supportsPropertyChange.removePropertyChangeListener(this.getForwardingListener());
        }
    }

    public final void removeAndAddForwardingListener(Object object, Object object2) {
        this.removeForwardingListener(object);
        this.addForwardingListener(object2);
    }

    public abstract boolean contains(double var1, double var3);
}

