/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.console;

import edu.neu.ccs.console.ConsoleGateway;
import edu.neu.ccs.console.ConsoleWindow;
import edu.neu.ccs.util.JPTConstants;
import edu.neu.ccs.util.SystemUtilities;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.io.Serializable;
import javax.swing.JLabel;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;

final class ConsoleTextPane
extends JTextPane
implements JPTConstants,
Serializable {
    public static final int OUT = 0;
    public static final int ERR = 1;
    public static final int IN = 2;
    private transient String endl = null;
    private int start = 0;
    private StyleContext context = null;
    private DefaultStyledDocument doc = null;
    private Style base = null;
    private Color[] color = new Color[]{Color.black, Color.black, Color.black};
    private ConsoleWindow window = null;
    protected static final int minFontSize = 10;
    protected static final int maxFontSize = 72;
    private int fontSize = 10;

    private ConsoleTextPane() {
        this.endl = SystemUtilities.getLineSeparator();
    }

    public ConsoleTextPane(ConsoleWindow consoleWindow) {
        this();
        this.window = consoleWindow;
        this.context = new StyleContext();
        this.doc = new DefaultStyledDocument(this.context);
        this.setStyledDocument(this.doc);
        String string = ConsoleGateway.getMonospacedFontFamilyName();
        this.base = this.context.getStyle("default");
        StyleConstants.setFontFamily(this.base, string);
        int n = new JLabel("0").getFont().getSize();
        if (n % 2 != 0) {
            ++n;
        }
        StyleConstants.setFontSize(this.base, n += 4);
        this.doc.setCharacterAttributes(0, this.doc.getLength(), this.base, false);
        this.setStream(0);
    }

    public void processComponentKeyEvent(KeyEvent keyEvent) {
        switch (keyEvent.getID()) {
            case 401: 
            case 402: {
                if (keyEvent.getKeyCode() != 10 && keyEvent.getKeyCode() != 8) break;
                keyEvent.consume();
                return;
            }
            default: {
                if (this.getCaretPosition() < this.start || this.getSelectionStart() < this.start) {
                    this.beep();
                    keyEvent.consume();
                    return;
                }
                if (keyEvent.getKeyChar() == '\n' || keyEvent.getKeyChar() == '\r') {
                    try {
                        try {
                            this.doc.insertString(this.doc.getLength(), this.endl, this.getStyleFor(2));
                            this.fireConsoleInputPerformed(this.doc.getText(this.start, this.doc.getLength() - this.start));
                            keyEvent.consume();
                        }
                        catch (BadLocationException badLocationException) {}
                    }
                    catch (Throwable throwable) {}
                    return;
                }
                if (keyEvent.getKeyChar() != '\b' || this.getCaretPosition() != this.start) break;
                this.beep();
                keyEvent.consume();
                return;
            }
        }
        super.processComponentKeyEvent(keyEvent);
        this.setCharacterAttributes(this.getStyleFor(2), true);
    }

    public void append(String string, int n) {
        this.setStream(n);
        this.start = this.doc.getLength();
        this.setCaretPosition(this.start);
        try {
            this.doc.insertString(this.doc.getLength(), string, this.getStyleFor(n));
        }
        catch (BadLocationException badLocationException) {}
        this.start = this.doc.getLength();
        this.setCaretPosition(this.start);
    }

    public void replaceSelection(String string) {
        if (this.getSelectionStart() >= this.start) {
            super.replaceSelection(string);
        } else {
            this.beep();
        }
    }

    public void cut() {
        if (this.getSelectionStart() >= this.start) {
            super.cut();
        } else {
            this.beep();
        }
    }

    public void paste() {
        if (this.getSelectionStart() >= this.start) {
            super.paste();
        } else {
            this.beep();
        }
    }

    public final String getFontFamilyName() {
        return StyleConstants.getFontFamily(this.base);
    }

    public final int getFontSize() {
        return this.fontSize;
    }

    public static final int getMinimumFontSize() {
        return 10;
    }

    public static final int getMaximumFontSize() {
        return 72;
    }

    public final void setFontSize(int n) {
        if (n < 10) {
            n = 10;
        } else if (n > 72) {
            n = 72;
        }
        Style style = this.context.addStyle(null, this.context.getStyle("default"));
        StyleConstants.setFontSize(style, n);
        StyleConstants.setFontSize(this.base, n);
        this.doc.setCharacterAttributes(0, this.doc.getLength(), style, false);
        this.fontSize = n;
    }

    public void setStream(int n) {
        if (n == 2) {
            this.start = this.doc.getLength();
            this.setCaretPosition(this.start);
            this.setCharacterAttributes(this.getStyleFor(n), true);
            this.setEditable(true);
            this.requestFocus();
        } else {
            this.setEditable(false);
            this.transferFocus();
        }
    }

    public void setInputColor(Color color) {
        this.color[2] = color;
    }

    public Color getInputColor() {
        return this.color[2];
    }

    public void setOutputColor(Color color) {
        this.color[0] = color;
    }

    public Color getOutputColor() {
        return this.color[0];
    }

    public void setErrorColor(Color color) {
        this.color[1] = color;
    }

    public Color getErrorColor() {
        return this.color[1];
    }

    private void fireConsoleInputPerformed(String string) {
        this.window.consoleInputPerformed(string);
    }

    private Style getStyleFor(int n) {
        Style style = this.context.addStyle(null, this.base);
        StyleConstants.setForeground(style, this.color[n]);
        return style;
    }

    private void beep() {
        new DefaultEditorKit.BeepAction().actionPerformed(new ActionEvent(this, 1001, "beep"));
    }
}

