/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.codec;

import edu.neu.ccs.Stringable;
import edu.neu.ccs.XObject;
import edu.neu.ccs.codec.Codec;
import edu.neu.ccs.codec.CountPrefixCodec;
import edu.neu.ccs.codec.EscapedCodec;
import edu.neu.ccs.util.JPTError;
import java.text.ParseException;
import java.util.Hashtable;

public class CodecUtilities {
    private static Hashtable codecs = null;

    public static String[] decode(String string) {
        if (!CodecUtilities.areCodecsInstalled()) {
            CodecUtilities.installStandardCodecs();
        }
        if (string.length() < 3) {
            throw new JPTError("Data is not valid encoded data: " + string);
        }
        String string2 = string.substring(0, 3);
        string = string.substring(3);
        Codec codec = (Codec)codecs.get(string2);
        if (codec == null) {
            throw new JPTError("Codec identifier not recognized: " + string2);
        }
        try {
            return codec.decode(string);
        }
        catch (ParseException parseException) {
            throw new JPTError("Parse exception while decoding data: " + parseException.getMessage());
        }
    }

    public static String encode(String[] stringArray) {
        return CodecUtilities.encode(stringArray, CodecUtilities.getDefaultCodec());
    }

    public static String encode(String[] stringArray, String string) {
        Codec codec;
        if (!CodecUtilities.areCodecsInstalled()) {
            CodecUtilities.installStandardCodecs();
        }
        if ((codec = (Codec)codecs.get(string)) == null) {
            throw new JPTError("Codec identifier not recognized: " + string);
        }
        return String.valueOf(codec.getPrefix()) + codec.encode(stringArray);
    }

    public static String encode(Stringable[] stringableArray) {
        return CodecUtilities.encode(stringableArray, CodecUtilities.getDefaultCodec());
    }

    public static String encode(Stringable[] stringableArray, String string) {
        return CodecUtilities.encode(XObject.toStringArray(stringableArray), string);
    }

    public static String getDefaultCodec() {
        if (!CodecUtilities.areCodecsInstalled()) {
            CodecUtilities.installStandardCodecs();
        }
        return "CPC";
    }

    public static void installCodec(Codec codec) {
        codecs.put(codec.getPrefix(), codec);
    }

    private static boolean areCodecsInstalled() {
        return codecs != null;
    }

    private static void installStandardCodecs() {
        codecs = new Hashtable();
        CodecUtilities.installCodec(new CountPrefixCodec());
        CodecUtilities.installCodec(new EscapedCodec());
    }
}

