/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs;

import edu.neu.ccs.Stringable;
import edu.neu.ccs.XDouble;
import edu.neu.ccs.codec.CodecUtilities;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.text.ParseException;
import java.util.StringTokenizer;
import javax.swing.event.SwingPropertyChangeSupport;

public final class XPoint2D
extends Point2D.Double
implements Cloneable,
Serializable,
Stringable {
    protected static final String X_PROPERTY = "x";
    protected static final String Y_PROPERTY = "y";
    protected SwingPropertyChangeSupport changeAdapter = new SwingPropertyChangeSupport(this);

    public XPoint2D() {
    }

    public XPoint2D(Point2D point2D) {
        this.setValue(point2D);
    }

    public XPoint2D(double d, double d2) {
        this.setValue(d, d2);
    }

    public XPoint2D(String string) throws ParseException {
        this.fromStringData(string);
    }

    public String toStringData() {
        return this.toString();
    }

    public void fromStringData(String string) throws ParseException {
        if (string == null) {
            throw new ParseException("Input was null.", -1);
        }
        String[] stringArray = XPoint2D.decodeIntoPair(string);
        double d = XDouble.parseDouble(stringArray[0]);
        double d2 = XDouble.parseDouble(stringArray[1]);
        this.setValue(d, d2);
    }

    public String toString() {
        return "[" + this.x + ";" + this.y + "]";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String[] decodeIntoPair(String string) throws ParseException {
        String string2 = "Data string is missing or empty";
        String string3 = "Expected [x;y] or (x,y) with x and y of type double.";
        if (string == null) {
            throw new ParseException("Data string is missing or empty", 0);
        }
        String string4 = string.trim();
        if (string4.length() == 0) {
            throw new ParseException("Data string is missing or empty", 0);
        }
        String[] stringArray = null;
        int n = string4.length() - 1;
        boolean bl = string4.charAt(0) == '[' && string4.charAt(n) == ']' || string4.charAt(0) == '(' && string4.charAt(n) == ')';
        if (!bl) return CodecUtilities.decode(string);
        String string5 = string4.charAt(0) == '[' ? ";" : ",";
        String string6 = string4.substring(1, n);
        StringTokenizer stringTokenizer = new StringTokenizer(string6, string5);
        int n2 = stringTokenizer.countTokens();
        if (n2 != 2) throw new ParseException("Expected [x;y] or (x,y) with x and y of type double.", string.length());
        stringArray = new String[]{stringTokenizer.nextToken(), stringTokenizer.nextToken()};
        return stringArray;
    }

    public void setValue(Point2D point2D) {
        if (point2D != null) {
            this.setValue(point2D.getX(), point2D.getY());
        }
    }

    public void setValue(double d, double d2) {
        double d3 = this.x;
        double d4 = this.y;
        this.x = d;
        this.y = d2;
        if (d != d3) {
            this.changeAdapter.firePropertyChange(X_PROPERTY, new Double(d3), new Double(d));
        }
        if (d2 != d4) {
            this.changeAdapter.firePropertyChange(Y_PROPERTY, new Double(d4), new Double(d2));
        }
    }

    public double radius() {
        return this.distance(0.0, 0.0);
    }

    public double radiusSq() {
        return this.distanceSq(0.0, 0.0);
    }

    public double angleInRadians() {
        return XPoint2D.angleInRadians(1.0, 0.0, this.x, this.y);
    }

    public double angleInDegrees() {
        return Math.toDegrees(this.angleInRadians());
    }

    public static double angleInRadians(Point2D point2D, Point2D point2D2) {
        if (point2D != null && point2D2 != null) {
            return XPoint2D.angleInRadians(point2D.getX(), point2D.getY(), point2D2.getX(), point2D2.getY());
        }
        return 0.0;
    }

    public static double angleInRadians(double d, double d2, double d3, double d4) {
        double d5 = Math.atan2(d4, d3) - Math.atan2(d2, d);
        if (d5 < 0.0) {
            d5 += Math.PI * 2;
        }
        return d5;
    }

    public static double angleInDegrees(Point2D point2D, Point2D point2D2) {
        return Math.toDegrees(XPoint2D.angleInRadians(point2D, point2D2));
    }

    public static double angleInDegrees(double d, double d2, double d3, double d4) {
        return Math.toDegrees(XPoint2D.angleInRadians(d, d2, d3, d4));
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changeAdapter.addPropertyChangeListener(propertyChangeListener);
    }

    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.changeAdapter.addPropertyChangeListener(string, propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changeAdapter.removePropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.changeAdapter.removePropertyChangeListener(string, propertyChangeListener);
    }
}

