/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs;

import edu.neu.ccs.Colors;
import edu.neu.ccs.XLong;
import edu.neu.ccs.XObject;
import edu.neu.ccs.filter.FilterException;
import edu.neu.ccs.filter.RangeFilter;
import edu.neu.ccs.util.Hex;
import java.awt.Color;
import java.text.ParseException;
import java.util.StringTokenizer;

public final class XColor
extends XObject {
    private Color color = Color.black;

    public XColor() {
    }

    public XColor(Color color) {
        this.setValue(color);
    }

    public XColor(int n, int n2, int n3) {
        this(new Color(n, n2, n3));
    }

    public XColor(int n, int n2, int n3, int n4) {
        this(new Color(n, n2, n3, n4));
    }

    public XColor(float f, float f2, float f3) {
        this(new Color(f, f2, f3));
    }

    public XColor(float f, float f2, float f3, float f4) {
        this(new Color(f, f2, f3, f4));
    }

    public XColor(String string) throws ParseException {
        this.fromStringData(string);
    }

    public void fromStringData(String string) throws ParseException {
        if (string == null) {
            throw new ParseException("Color string data is null.", -1);
        }
        if (string.length() == 0) {
            throw new ParseException("Color string data has zero length.", -1);
        }
        if ((string = string.trim()).length() == 0) {
            throw new ParseException("Color string data contains only white space.", -1);
        }
        char c = string.charAt(0);
        if (Character.isLetter(c)) {
            Color color = Colors.getColorFromName(string);
            if (color != null) {
                this.setValue(color);
                return;
            }
            throw new ParseException("Unrecognized color name in color string data.", -1);
        }
        if (c == '#') {
            this.setValue(this.getColorFromHexidecimal(string));
            return;
        }
        if (Character.isDigit(c)) {
            this.setValue(this.getColorFromDecimal(string));
            return;
        }
        throw new ParseException("Color string data must be decimal r,g,b,alpha data, or hex data, or a name.", -1);
    }

    private Color getColorFromDecimal(String string) throws ParseException {
        String string2 = "Decimal color data must have the form r,g,b or r,g,b,alpha with values between 0 and 255";
        StringTokenizer stringTokenizer = new StringTokenizer(string, ", ");
        int n = stringTokenizer.countTokens();
        if (n < 3 || n > 4) {
            throw new ParseException(string2, -1);
        }
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = stringTokenizer.nextToken();
            ++n2;
        }
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 255;
        try {
            RangeFilter.Long longVal = new RangeFilter.Long(0L, 255L);
            XLong xLong = (XLong)longVal.filterStringable(new XLong(stringArray[0]));
            n3 = (int)xLong.getValue();
            XLong xLong2 = (XLong)longVal.filterStringable(new XLong(stringArray[1]));
            n4 = (int)xLong2.getValue();
            XLong xLong3 = (XLong)longVal.filterStringable(new XLong(stringArray[2]));
            n5 = (int)xLong3.getValue();
            if (n == 4) {
                XLong xLong4 = (XLong)longVal.filterStringable(new XLong(stringArray[3]));
                n6 = (int)xLong4.getValue();
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new ParseException(string2, -1);
        }
        catch (FilterException filterException) {
            throw new ParseException(string2, -1);
        }
        return new Color(n3, n4, n5, n6);
    }

    private Color getColorFromHexidecimal(String string) throws ParseException {
        boolean bl;
        String string2 = "Hexidecimal color data must have the form #... with 3, 4, 6, or 8 hex digits";
        int n = (string = string.substring(1)).length();
        boolean bl2 = bl = n == 3 || n == 4 || n == 6 || n == 8;
        if (bl) {
            int n2 = 0;
            while (n2 < n) {
                if (!Hex.isHexDigit(string.charAt(n2))) {
                    bl = false;
                    break;
                }
                ++n2;
            }
        }
        if (!bl) {
            throw new ParseException(string2, -1);
        }
        StringBuffer stringBuffer = new StringBuffer(8);
        if (n <= 4) {
            char c = string.charAt(0);
            char c2 = string.charAt(1);
            char c3 = string.charAt(2);
            stringBuffer.append(c);
            stringBuffer.append(c);
            stringBuffer.append(c2);
            stringBuffer.append(c2);
            stringBuffer.append(c3);
            stringBuffer.append(c3);
            if (n == 4) {
                char c4 = string.charAt(3);
                stringBuffer.append(c4);
                stringBuffer.append(c4);
            }
            string = stringBuffer.toString();
            n *= 2;
        }
        String string3 = string.substring(0, 2);
        String string4 = string.substring(2, 4);
        String string5 = string.substring(4, 6);
        String string6 = n == 8 ? string.substring(6, 8) : "ff";
        return new Color(Hex.hexToInt(string3), Hex.hexToInt(string4), Hex.hexToInt(string5), Hex.hexToInt(string6));
    }

    public String toStringData() {
        int n = this.color.getRed();
        int n2 = this.color.getGreen();
        int n3 = this.color.getBlue();
        int n4 = this.color.getAlpha();
        if (n4 == 255) {
            return String.valueOf(n) + ", " + n2 + ", " + n3;
        }
        return String.valueOf(n) + ", " + n2 + ", " + n3 + ", " + n4;
    }

    public String toString() {
        return this.toStringData();
    }

    public boolean equals(Object object) {
        if (object instanceof XColor) {
            return this.getValue().equals(((XColor)object).getValue());
        }
        return false;
    }

    public int hashCode() {
        return this.getValue().hashCode();
    }

    public void setValue(Color color) {
        Color color2 = this.color;
        if (color == null) {
            color = Color.black;
        }
        this.color = color;
        if (!this.getValue().equals(color2)) {
            this.changeAdapter.firePropertyChange("value", color2, this.getValue());
        }
    }

    public void setValue(int n, int n2, int n3) {
        this.setValue(new Color(n, n2, n3));
    }

    public void setValue(int n, int n2, int n3, int n4) {
        this.setValue(new Color(n, n2, n3, n4));
    }

    public void setValue(float f, float f2, float f3) {
        this.setValue(new Color(f, f2, f3));
    }

    public void setValue(float f, float f2, float f3, float f4) {
        this.setValue(new Color(f, f2, f3, f4));
    }

    public Color getValue() {
        return this.color;
    }

    public static Color getColor(String string) {
        try {
            return XColor.parseColor(string);
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public static Color parseColor(String string) throws ParseException {
        return new XColor((String)string).color;
    }

    public static String colorToString(Color color) {
        return new XColor(color).toStringData();
    }

    public static Color[] toPrimitiveArray(XColor[] xColorArray) {
        if (xColorArray == null) {
            return null;
        }
        Color[] colorArray = new Color[xColorArray.length];
        int n = 0;
        while (n < colorArray.length) {
            if (xColorArray[n] != null) {
                colorArray[n] = xColorArray[n].getValue();
            }
            ++n;
        }
        return colorArray;
    }

    public static XColor[] toXArray(Color[] colorArray) {
        if (colorArray == null) {
            return null;
        }
        XColor[] xColorArray = new XColor[colorArray.length];
        int n = 0;
        while (n < xColorArray.length) {
            if (colorArray[n] != null) {
                xColorArray[n] = new XColor(colorArray[n]);
            }
            ++n;
        }
        return xColorArray;
    }
}

