/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs;

import edu.neu.ccs.XNumber;
import java.math.BigDecimal;
import java.text.ParseException;

public class XBigDecimal
extends XNumber {
    private BigDecimal value = new BigDecimal(0.0);

    public XBigDecimal() {
    }

    public XBigDecimal(BigDecimal bigDecimal) {
        this.setValue(bigDecimal);
    }

    public XBigDecimal(String string) throws ParseException {
        this.fromStringData(string);
    }

    public void fromStringData(String string) throws ParseException {
        if (string == null) {
            throw new ParseException("Input was null.", -1);
        }
        BigDecimal bigDecimal = this.value;
        try {
            this.setValue(new BigDecimal(string));
        }
        catch (NumberFormatException numberFormatException) {
            throw new ParseException("Not a valid BigDecimal.", string.length());
        }
        this.changeAdapter.firePropertyChange("value", bigDecimal, string);
    }

    public String toStringData() {
        return this.value.toString();
    }

    public byte byteValue() {
        BigDecimal bigDecimal = new BigDecimal("127");
        BigDecimal bigDecimal2 = new BigDecimal("-128");
        if (this.getValue().compareTo(bigDecimal) > 0 || this.getValue().compareTo(bigDecimal2) < 0) {
            throw new NumberFormatException("Number beyond precision of a byte.");
        }
        return (byte)this.getValue().intValue();
    }

    public short shortValue() {
        BigDecimal bigDecimal = new BigDecimal("32767");
        BigDecimal bigDecimal2 = new BigDecimal("-32768");
        if (this.getValue().compareTo(bigDecimal) > 0 || this.getValue().compareTo(bigDecimal2) < 0) {
            throw new NumberFormatException("Number beyond precision of a short.");
        }
        return (short)this.getValue().intValue();
    }

    public int intValue() {
        BigDecimal bigDecimal = new BigDecimal("2147483647");
        BigDecimal bigDecimal2 = new BigDecimal("-2147483648");
        if (this.getValue().compareTo(bigDecimal) > 0 || this.getValue().compareTo(bigDecimal2) < 0) {
            throw new NumberFormatException("Number beyond precision of an int.");
        }
        return this.getValue().intValue();
    }

    public long longValue() {
        BigDecimal bigDecimal = new BigDecimal("9223372036854775807");
        BigDecimal bigDecimal2 = new BigDecimal("-9223372036854775808");
        if (this.getValue().compareTo(bigDecimal) > 0 || this.getValue().compareTo(bigDecimal2) < 0) {
            throw new NumberFormatException("Number beyond precision of a long.");
        }
        return this.getValue().longValue();
    }

    public float floatValue() {
        return this.getValue().floatValue();
    }

    public double doubleValue() {
        return this.getValue().doubleValue();
    }

    public boolean equals(Object object) {
        if (object instanceof XBigDecimal) {
            return this.getValue().equals(((XBigDecimal)object).getValue());
        }
        return this.getValue().equals(object);
    }

    public int hashCode() {
        return this.getValue().hashCode();
    }

    public String toString() {
        return this.value.toString();
    }

    public void setValue(BigDecimal bigDecimal) {
        BigDecimal bigDecimal2 = this.value;
        if (bigDecimal == null) {
            bigDecimal = new BigDecimal(0.0);
        }
        this.value = bigDecimal;
        if (!this.getValue().equals(bigDecimal2)) {
            this.changeAdapter.firePropertyChange("value", bigDecimal2, this.getValue());
        }
    }

    public BigDecimal getValue() {
        return this.value;
    }

    public static BigDecimal[] toPrimitiveArray(XBigDecimal[] xBigDecimalArray) {
        if (xBigDecimalArray == null) {
            return null;
        }
        BigDecimal[] bigDecimalArray = new BigDecimal[xBigDecimalArray.length];
        int n = 0;
        while (n < bigDecimalArray.length) {
            if (xBigDecimalArray[n] != null) {
                bigDecimalArray[n] = xBigDecimalArray[n].getValue();
            }
            ++n;
        }
        return bigDecimalArray;
    }

    public static XBigDecimal[] toXArray(BigDecimal[] bigDecimalArray) {
        if (bigDecimalArray == null) {
            return null;
        }
        XBigDecimal[] xBigDecimalArray = new XBigDecimal[bigDecimalArray.length];
        int n = 0;
        while (n < xBigDecimalArray.length) {
            if (bigDecimalArray[n] != null) {
                xBigDecimalArray[n] = new XBigDecimal(bigDecimalArray[n]);
            }
            ++n;
        }
        return xBigDecimalArray;
    }
}

