/* @(#)Interactions.java 1.0  20 September 2004 */

/* Useful imports */

import edu.neu.ccs.*;
import edu.neu.ccs.gui.*;
import edu.neu.ccs.codec.*;
import edu.neu.ccs.console.*;
import edu.neu.ccs.filter.*;
import edu.neu.ccs.jpf.*;
import edu.neu.ccs.parser.*;
import edu.neu.ccs.pedagogy.*;
import edu.neu.ccs.quick.*;
import edu.neu.ccs.util.*;

import java.awt.*;
import java.awt.event.*;
import java.awt.geom.*;
import java.awt.font.*;
import java.awt.image.*;
import javax.swing.*;
import javax.swing.border.*;

import com.sun.rsasign.b;
import com.sun.rsasign.t;

import java.io.*;
import java.util.*;
import java.math.*;
import java.beans.*;
import java.lang.reflect.*;
import java.net.URL;
import java.util.regex.*;

// import java.text.*;

public class Interactions extends JPF 
{
    
    public static void main(String[] args) { 
        // To optionally adjust the look and feel,
        // remove the comments from one of the two statements below.
        
        // LookAndFeelTools.showSelectLookAndFeelDialog();
        // LookAndFeelTools.adjustAllDefaultFontSizes(2);
        
        new Interactions();
    }
    
    ///////////////////////////////////////////////////////////
    // Place your actual methods here.                       //
    ///////////////////////////////////////////////////////////
  	/*----------------------------------------------------------------------- 
	 Explore city constructors
	------------------------------------------------------------------------- */
    public void cityConstructors(){
    
        City nyc = new City();
        console.out.println(nyc);
        
        City boston = new City(02115, "Boston", "MA", 78.123345, 40.987654);
        console.out.println(boston);
        
        City bos = new City(boston);
        console.out.println(boston);
        
        console.out.println("Testing zip code converter");
        console.out.println(12345 == boston.decimal("12345"));
        
        console.out.println(2145 == boston.decimal("02145"));
        
        console.out.println(nyc.same(boston) == false);
    }
    

	/*----------------------------------------------------------------------- 
	 Explore GUI iterator for input of list of cities
	------------------------------------------------------------------------- */
    public void tryInGuiRange(){
    
        AListOfCities cities = new MTListOfCities();
        
        IRange it = new InGuiRange();
        while(it.hasMore()){
            cities = new ConsListOfCities((City)it.current(), cities);
            console.out.println("Next in City: " + ((ConsListOfCities)cities).first); 
            it = it.next();
        }
        
        console.out.println("Done with gui input iterator.");
    }

	/*----------------------------------------------------------------------- 
	 Explore buffered file channel and iterator for input of list of cities
	------------------------------------------------------------------------- */
    public void tryInFileRangeBuffered(){
    
        City[] cities = new City[20];
        int i = 0;
        
        IRange it = new InFileRangeBuffered();
        while (it.hasMore()){  
            cities[i] = (City)it.current();
            console.out.println("Next in City: " + cities[i]);
            i++;
            it = it.next();
        }
        
        console.out.println("Done with buffered file input iterator.");
    }

    
	/*----------------------------------------------------------------------- 
	 Explore console channel and iterator for input of list of cities
	------------------------------------------------------------------------- */
    public void tryInConsoleRange(){
   
       City[] cities = new City[20];
       int i = 0;
       
       InConsoleRange it1 = new InConsoleRange();
       while (it1.hasMore()){
       		cities[i] = (City)it1.current();
        
       		console.out.println(cities[i]);
       		i++;
       		it1.next();
       }
   }

	/*----------------------------------------------------------------------- 
	 Explore algorithms class skeleton
	------------------------------------------------------------------------- */
    public void tryAlgorithms(){

    		Algorithms a = new Algorithms();

    	    
    }
    
    
  	/*----------------------------------------------------------------------- 
	 Explore file output range
	-------------------------------------------------------------------------*/
    public void tryOutFileRange(){
    
        City nyc = new City();
        console.out.println(nyc);
        
        City boston = new City("02115", "Boston", "MA", 78.123345, 40.987654);
        console.out.println(boston);
        
        City bos = new City(boston);
        console.out.println(boston);
        
        City[] cities = new City[]{boston, nyc, bos};

        IRange it = new OutFileRange(cities);
		while (it.hasMore()){
            console.out.println("Next out City: " + (City)it.current());
            it = it.next();
        }
        
        console.out.println("Done with file output iterator.");
        
    }
 


    /*----------------------------------------------------------------------- 
	 Run the test suite for cities
	------------------------------------------------------------------------- */
    public void TestSuite(){
   
       Examples e = new Examples();
       
       e.runTests();
   }
    
    /*----------------------------------------------------------------------- 
	 Helper method
	------------------------------------------------------------------------- */
    /** convert a String to int - if possible */
    protected int intValue(String s){
        int n = 0;
        try{
            n = (new XInt(s)).intValue();
        }
        catch(java.text.ParseException e){
            console.out.println("Cannot convert " + s + " to integer.");
        }
        return n;
    }
 }

