/* Algorithms.java  16 April 2003 */

import edu.neu.ccs.*;
import edu.neu.ccs.util.*;
import edu.neu.ccs.console.*;

import java.awt.*;
import java.math.*;
import java.util.*;

public class Algorithms implements ConsoleAware{
      
	// orMap method implemented recursively
	public boolean orMap(IRange it, ISelect predicate){
		if (it.hasMore())
			if (predicate.select(it.current()))
				return true;
			else
				return orMap(it.next(), predicate);
		else
			return false;
	}
	
	
	// filter method implemented recursively
	public AListOfCities filter(IRange it, ISelect predicate){
		if (it.hasMore())
			if (predicate.select(it.current()))
				return new ConsListOfCities(((City)it.current()), 
						              filter(it.next(), predicate));
			else
				return filter(it.next(), predicate);
		else 
			return new MTListOfCities();
	}
	
	// filter implemented with Java 'while' loop
	AListOfCities filterWhile(IRange it, ISelect predicate){
		AListOfCities acc = new MTListOfCities();
		while(it.hasMore()){
			if (predicate.select(it.current()))
				acc = new ConsListOfCities(((City)it.current()), acc);
			it = it.next();
		}
		return acc;
	}
	
 }

