import java.awt.Color;
import java.util.*;

public class Examples implements Testable{
	
	Examples(){}

	Board b = new Board();
	Board bb = new Board();
	
	/*
	 *  o o o o o o o
	 *  o o b o o b o
	 *  r o r b r b o
	 *  r r r r b b o
	 *  r b r b b b b
	 *  r r b r b r r
	 * 
	 * wins: black row (1, 3) (1, 4) (1, 5) (1, 6)
	 *       black column (4, 5)
	 *       black nw-se (4 , 2) (3, 3) (2, 4) (1, 5)
	 *       black ne-sw (3, 5) (2, 4) (1, 3) (0 2)
	 *       red   row (2, 0) (2, 1) (2, 2) (2, 3)
	 *       red   column (3, 0)
	 *       red   ne-sw (3, 0) (2, 1) (1, 2) (0, 3)
	 *       red   nw-se (3, 4) (2, 3) (1, 2) (0, 1)
	 */
	public void initbb(){
		// bottom row (row 0)
		this.bb.put(0, this.bb.red);
		this.bb.put(1, this.bb.red);
		this.bb.put(2, this.bb.black);
		this.bb.put(3, this.bb.red);
		this.bb.put(4, this.bb.black);
		this.bb.put(5, this.bb.red);
		this.bb.put(6, this.bb.red);
		// row 1
		this.bb.put(0, this.bb.red);
		this.bb.put(1, this.bb.black);
		this.bb.put(2, this.bb.red);
		this.bb.put(3, this.bb.black);
		this.bb.put(4, this.bb.black);
		this.bb.put(5, this.bb.black);
		this.bb.put(6, this.bb.black);
		// row 2
		this.bb.put(0, this.bb.red);
		this.bb.put(1, this.bb.red);
		this.bb.put(2, this.bb.red);
		this.bb.put(3, this.bb.red);
		this.bb.put(4, this.bb.black);
		this.bb.put(5, this.bb.black);
		// row 3
		this.bb.put(0, this.bb.red);
		this.bb.put(2, this.bb.red);
		this.bb.put(3, this.bb.black);
		this.bb.put(4, this.bb.red);
		this.bb.put(5, this.bb.black);
		// row 4
		this.bb.put(2, this.bb.black);
		this.bb.put(5, this.bb.black);
	}
	
	/*
	 * o o o o o o o 
	 * o o o o o r o 
	 * o o o o o r o  
	 * o o o o o r o 
	 * o o o o o r o  
	 * b b b b r b o 
	 */
	
	public void initb(){
		this.b.put(4, this.b.red);
		this.b.put(5, this.b.black);
		this.b.put(5, this.b.red);
		this.b.put(3, this.b.black);
		this.b.put(2, this.b.black);
		this.b.put(1, this.b.black);
		this.b.put(0, this.b.black);
		this.b.put(5, this.b.red);
		this.b.put(5, this.b.red);
		this.b.put(5, this.b.red);
	}

	public void tests(Tester t){      	

        // Your examples and tests go here.
		
		// are the wins correctly reported
		this.initbb();
			/*
			 * wins: black row (1, 3) (1, 4) (1, 5) (1, 6)
			 *       black column (4, 5)
			 *       black nw-se (4 , 2) (3, 3) (2, 4) (1, 5)
			 *       black ne-sw (3, 5) (2, 4) (1, 3) (0 2)
			 *       red   row (2, 0) (2, 1) (2, 2) (2, 3)
			 *       red   column (3, 0)
			 *       red   ne-sw (3, 0) (2, 1) (1, 2) (0, 3)
			 *       red   nw-se (3, 4) (2, 3) (1, 2) (0, 1)
			 */
		t.test("check win black row", true, this.bb.checkWin(1, 3, this.b.black));
		t.test("check win black row", true, this.bb.checkWin(1, 5, this.b.black));
		t.test("check win black column", true, this.bb.checkWin(4, 5, this.b.black));
		t.test("check win black nw-se", true, this.bb.checkWin(4, 2, this.b.black));
		t.test("check win black nw-se", true, this.bb.checkWin(2, 4, this.b.black));
		t.test("check win black ne-sw", true, this.bb.checkWin(3, 5, this.b.black));
		
		t.test("check win red row", true, this.bb.checkWin(2, 3, this.b.red));
		t.test("check win red column", true, this.bb.checkWin(3, 0, this.b.red));
		t.test("check win red ne-sw", true, this.bb.checkWin(2, 1, this.b.red));
		t.test("check win red ne-sw", true, this.bb.checkWin(1, 2, this.b.red));
		t.test("check win red nw-se", true, this.bb.checkWin(3, 4, this.b.red));
		t.test("check win red nw-se", true, this.bb.checkWin(0, 1, this.b.red));
		
		this.initb();
		
		t.test("samePlayer", false, this.b.samePlayer(0, 5, this.b.red));
		t.test("samePlayer", true, this.b.samePlayer(0, 3, this.b.black));
		t.test("samePlayer", true, this.b.samePlayer(3, 5, this.b.red));

		t.test("checkCol", true, this.b.checkCol(4, 5, this.b.red));
		t.test("checkCol", false, this.b.checkCol(2, 5, this.b.black));
		t.test("checkCol", false, this.b.checkCol(4, 5, this.b.black));

		t.test("checkRow", true, this.b.checkRow(0, 3, this.b.black));
		
		t.testReport();
		t.fullTestReport();
	}
		
	// run all tests
	public void go(){
		Tester tester = new Tester();
		tester.runTests(this);
	}
	
	// run all tests given by the Exampes class
	public static void main(String[] argv){
		Examples e = new Examples();
		e.go();
	}
	
}