import java.util.*;
import edu.neu.ccs.*;
import edu.neu.ccs.gui.*;
import edu.neu.ccs.codec.*;
import edu.neu.ccs.console.*;
import edu.neu.ccs.filter.*;
import edu.neu.ccs.jpf.*;
import edu.neu.ccs.parser.*;
import edu.neu.ccs.pedagogy.*;
import edu.neu.ccs.quick.*;
import edu.neu.ccs.util.*;

// administrator and compute player for the game
public class ConnectFour implements ConsoleAware{
	Board board;
	boolean done;
	String player;
	String red = "*";
	String black = "#";
	
	ConnectFour(){
		// initialize the board, start the game
		this.player = this.startGame();
		
		// keep playing till the game is over
		while (!this.done)
			this.nextTurn();
		console.out.println("Thank you for the game, " + this.player + ".");
	}
	
	// initialize the board and invite the oponent to start the game
	public String startGame(){
		this.board = new Board();
		this.done = false;
		console.out.println("Welcome to the Connect Four game.");
		return console.in.demandString("Type in your name: ");
	}

	// one turn of the game - user and the computer
	public void nextTurn(){
		try{
			int n = console.in.requestInt("Your move:>");
			console.out.println(this.myMove(n));  
			showBoard();
		}
		catch(CancelledException e){
			this.done = true;
			console.out.println("Goodbye");
		}
	}

	// record user's move, make own, report oponent's win
	public String myMove(int col){
		if (validMove(col, this.black))
			if (!this.done)
				return "I moved to column " + makeMove();
			else
				return "Congratulations, you win.";
		else 
			return "Invalid move.";
	}
	
	public boolean validMove(int col, String color){
		int row = this.board.put(col, color);
		if (row >= 0){
			if (this.board.checkWin(row, col, color)){
				this.done = true;
			}
			return true;
		}			
		else
			return false;
		// check if valid move.
		// check if winning move - if yes, set done to true 
	}

	// select the move for the computer - report win when done
	public String makeMove(){
		int col = MathUtilities.randomInt(0, 6);
		while (!validMove(col, this.red)){
			col = MathUtilities.randomInt(0, 6);
		}
		if (this.done)
			return String.valueOf(col) + " --- I win!";
		else
			return String.valueOf(col);	
	}
	
	// facilitate the display of the board
	public void showBoard(){
		console.out.println(this.board.toString());
	}
	
}