import java.util.*;

public class Board{
	int maxrow = 5;
	int maxcol = 6;
	String red = "*";
	String black = "#";
	String top = "o";
	String fill = "-";
	
	// use a hash map to record played locations
	HashMap board = new HashMap();
	
	// record the top row for each column
	int[] tops = new int[]{-1, -1, -1, -1, -1, -1, -1};
	
	
	// return the row into which the piece was placed
	// return zero if placement is not valid
	public int put(int col, String player){
		if (player.equals(this.red) || player.equals(this.black)){
			// insert ...
			if (this.tops[col] == this.maxrow) // column already filled
				return -1;
			else{
				this.tops[col] = this.tops[col] + 1;
				this.board.put(new Loc(this.tops[col], col), player);
				return this.tops[col];
			}	
		}
		else // not a valid play
			return -1;			
	}
	
    //----------------------------------------------------------------
	// checking for a winner after the player mover to row and col
    //----------------------------------------------------------------
	
	// does the peg at the given location belong to the given player
	boolean samePlayer(int row, int col, String player){
		if ((this.board.containsKey(new Loc(row, col))) &&
		   this.board.get(new Loc(row, col)).equals(player))
			return true;
		else
			return false;			
	}
	
	// check if there are four pegs of the given player 
	// in the given column starting with the given row
	boolean checkCol(int row, int col, String player){
		if (row < 3)
			return false;
		else
			return this.samePlayer(row - 1, col, player) &&
			       this.samePlayer(row - 2, col, player) &&
				   this.samePlayer(row - 3, col, player);
	}
	
	// check if there are four pegs of the given player 
	// in the given row starting with the given column
	boolean checkRow(int row, int col, String player){
		return 
			// X O O O
		    (this.samePlayer(row, col + 1, player) &&
		     this.samePlayer(row, col + 2, player) &&
			 this.samePlayer(row, col + 3, player)) ||
			// O X O O
			(this.samePlayer(row, col - 1, player) &&
			 this.samePlayer(row, col + 1, player) &&
			 this.samePlayer(row, col + 2, player)) ||
			// O O X O 
			(this.samePlayer(row, col - 2, player) &&
			 this.samePlayer(row, col - 1, player) &&
			 this.samePlayer(row, col + 1, player)) ||
			// O O O X
			(this.samePlayer(row, col - 3, player) &&
			 this.samePlayer(row, col - 2, player) &&
			 this.samePlayer(row, col - 1, player));
	}

	// check if there are four pegs of the given player 
	// in the given NW to SE diagonal starting 
	// with the given row and column
	boolean checkNWtoSE(int row, int col, String player){
		return 
			// X O O O
		    (this.samePlayer(row + 1, col + 1, player) &&
		     this.samePlayer(row + 2, col + 2, player) &&
			 this.samePlayer(row + 3, col + 3, player)) ||
			// O X O O
			(this.samePlayer(row - 1, col - 1, player) &&
			 this.samePlayer(row + 1, col + 1, player) &&
			 this.samePlayer(row + 2, col + 2, player)) ||
			// O O X O 
			(this.samePlayer(row - 2, col - 2, player) &&
			 this.samePlayer(row - 1, col - 1, player) &&
			 this.samePlayer(row + 1, col + 1, player)) ||
			// O O O X
			(this.samePlayer(row - 3, col - 3, player) &&
			 this.samePlayer(row - 2, col - 2, player) &&
			 this.samePlayer(row - 1, col - 1, player));
	}
	
	// check if there are four pegs of the given player 
	// in the given NE to SW diagonal starting 
	// with the given row and column
	boolean checkNEtoSW(int row, int col, String player){
		return 
			// X O O O
		    (this.samePlayer(row + 1, col - 1, player) &&
		     this.samePlayer(row + 2, col - 2, player) &&
			 this.samePlayer(row + 3, col - 3, player)) ||
			// O X O O
			(this.samePlayer(row - 1, col + 1, player) &&
			 this.samePlayer(row + 1, col - 1, player) &&
			 this.samePlayer(row + 2, col - 2, player)) ||
			// O O X O 
			(this.samePlayer(row - 2, col + 2, player) &&
			 this.samePlayer(row - 1, col + 1, player) &&
			 this.samePlayer(row + 1, col - 1, player)) ||
			// O O O X
			(this.samePlayer(row - 3, col + 3, player) &&
			 this.samePlayer(row - 2, col + 2, player) &&
			 this.samePlayer(row - 1, col + 1, player));
	}
	
	// check if the player ended in a winning position
	boolean checkWin(int row, int col, String player){
		return this.checkRow(row, col, player) ||
		       this.checkCol(row, col, player) ||
			   this.checkNWtoSE(row, col, player) ||
			   this.checkNEtoSW(row, col, player);
	}

	// represent the board as a string
	public String toString(){
		String sboard = "Board: \n";
		for (int row = 5; row >= 0; row = row - 1)
			sboard = sboard + this.makeRow(row) + "\n";
		return sboard;
	}
	
	// represent one row of the board as a string
	public String makeRow(int row){
		String s = "";
		for (int col = 0; col < 7; col = col +1){
			if (this.board.containsKey(new Loc(row, col)))
				s = s + " " + this.board.get(new Loc(row, col));
			else
				s = s + " " + this.top;
		}
		return s;
	}

	// run the tests for this class
	public static void main (String[] argv){
		BoardTest bt = new BoardTest();
		bt.test();
	}
}

// class to represent a location on the board
class Loc{
	int x;
	int y;
	
	Loc(int x, int y){
		this.x = x;
		this.y = y;
	}
	
	// override equals to match if the coordinates are the same
	public boolean equals(Object obj){
		if (obj instanceof Loc)
			return this.x == ((Loc)obj).x
			    && this.y == ((Loc)obj).y;
		else 
			return false;
	}
	
	// mist override the hashCode to match equals
	public int hashCode(){
		return 10 * this.x + this.y;
	}
}

// class to test the class Board
class BoardTest{
	Board b = new Board();
	
	public void test(){
		System.out.println(this.b.toString());
		this.b.put(4, this.b.red);
		System.out.println(this.b.toString());
		this.b.put(5, this.b.black);
		System.out.println(this.b.toString());	
		this.b.put(5, this.b.red);
		this.b.put(3, this.b.black);
		this.b.put(2, this.b.black);
		this.b.put(1, this.b.black);
		this.b.put(0, this.b.black);
		this.b.put(5, this.b.red);
		this.b.put(5, this.b.red);
		this.b.put(5, this.b.red);
		System.out.println(this.b.toString());	

	}
}