import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;

import edu.neu.ccs.console.ConsoleAware;
import edu.neu.ccs.util.MathUtilities;

class TimerTests implements ConsoleAware{


    // SortAlgorithm selectarray = new SelectionArrSort();
	// SortAlgorithm insertarray = new InsertionArrSort();
	// SortAlgorithm insertlist  = new InsertionListSort();
	// SortAlgorithm bstsort     = new BinaryTreeSort();
	// SortAlgorithm quicklist   = new uickListSort();
	SortAlgorithm quickarray   = new QuickArrSort();
	
	// an arraylist of sorting algorithms to test	
	ArrayList sortAlgos = new ArrayList();
	
	Comparator byName = new ByName();
	
	// an arraylist of comparators to use
	ArrayList comparators = new ArrayList();
	
	// original data set of all cities available
	ArrayList alldata;
	
	// records of the start and end time
	long startTime;			// time of the start of the test
	long endTime;			// time of the end of the test

	// start the timer tests with the given test data sets
	TimerTests(ArrayList alldata){
		this.alldata = alldata;
		initAll();
	}
	
	// start the timer tests with the given test data sets
	TimerTests(IRange it){
		this.alldata = this.readData(it);
		initAll();
	}
	
	// initialize algorithms, etc
	public void initAll(){
		//this.sortAlgos.add(this.selectarray);
		//this.sortAlgos.add(this.insertarray);
		//this.sortAlgos.add(this.insertlist);
		//this.sortAlgos.add(this.bstsort);
		//this.sortAlgos.add(this.quicklist);	
		this.sortAlgos.add(this.quickarray);	
			
		this.comparators.add(this.byName);
	}


	// create the base data set for all tests
	public ArrayList readData(IRange it){
		ArrayList target = new ArrayList();
		for(;
			it.hasMore();
			it.next()){
			target.add(it.current());		
		}
		console.out.println("readData produced " + target.size() + " elements.");
		return target;
	}
	
	// produce an IRange for given dataset size from original data
	public IRange buildRandomData(ArrayList alldata, int size){
		// make a copy of the original arraylist
		ArrayList temp = (ArrayList)alldata.clone();
		ArrayList result = new ArrayList();
		
		if (size < temp.size()){
						
			// selecting elements at random index to add to the data set
			int index = 0;
			int loc;

			while (index < size){
				loc = MathUtilities.randomInt(0, temp.size() - 1);
				result.add(temp.get(loc));
				index = index + 1;
			}
		}
		console.out.println("Random data set of size " + 
				           result.size() + " initialized.");
		return new ArrayListRange(result, 0);
	}
		
	// produce an IRange for given dataset size from original data
	public IRange buildData(ArrayList alldata, int size){
		// make a copy of the original arraylist
		ArrayList temp = (ArrayList)alldata.clone();
		ArrayList result = new ArrayList();
		
		// leave only 'size' elements 
		// if size  desired is bigger than available, use available
		if (size < temp.size()){
						// start copying elements random index from the start
			int index = MathUtilities.randomInt(0, temp.size() - size);
			int limit = index + size;

			while (index < limit){
				result.add(temp.get(index));
				index = index + 1;
			}
		}
		console.out.println("Data set of size " + result.size() + " initialized.");
		return new ArrayListRange(result, 0);
	}
	
	// run one test of a given sorting algorithm
	// with the given comparator
	// and the desired size of data, random or sequentially selected
	public long runOneTest(SortAlgorithm algo, Comparator comp, 
                            int size, boolean random) {
		IRange sourceIt;
		IRange result;
		
		// construct an iterator to produce the desited data set
		if (random)
			sourceIt = buildRandomData(this.alldata, size);
		else
			sourceIt = buildData(this.alldata, size);
		
		this.startTime = (new Date()).getTime();
		result = algo.sort(sourceIt, comp);
		this.endTime = (new Date()).getTime();
		return this.endTime - this.startTime;
	}
	
	// a sample test for this class
	public void sampleTest(){
	
		long runtime = this.runOneTest(
				new QuickArrSort(),this.byName, 10000, false);

				console.out.println("Quick sort ArrayList time: " + 
						            runtime + "\n");
	}
		
	public static void main(String[] argv){
		TimerTests tt = new TimerTests(new InFileRangeBuffered());
		tt.sampleTest();
	}
}