import java.util.*;
import edu.neu.ccs.util.*;

class QuickArrSort implements SortAlgorithm{
	
	ArrayList input;
	
	// implementing SortAlgorithm interface
	public void initializeDataSet(IRange it){
		this.input = new ArrayList();
		while (it.hasMore()){
			this.input.add(it.current());
			it = it.next();
		}
	}
	
	// method that implements the SortAlgorithm interface
	public IRange sort(IRange it, Comparator comp){
		initializeDataSet(it);
		return new ArrayListRange(this.quickSortArr(this.input, comp), 0);		
	}
	
	// quicksort for ArrayList
	public ArrayList quickSortArr(ArrayList source, Comparator comp){
		qs(source, comp, 0, source.size() - 1);
		return source;
	}
	
	
	// helper method that sorts the interval between min and max
	public void qs(ArrayList data, Comparator comp, int min, int max) {
    		if ((data.size() == 0) || (max <= min))
                return;
           
		int s = partition(data, comp, min, max);
           
            qs(data, comp, min, s  );
            qs(data, comp, s+1, max);
    }
   

    /**
     * The partition helper function for quick sort
     * and related algorithms.
     *
     * If min < max then partition the data between
     * min and max and return s such that:
     *
     *     min <= s < max
     * 
     *     if min <= u <= s and s+1 <= v <= max
     *         then data[u] <= data[v]
     */
    public static int partition(ArrayList data, Comparator comp,
                                int min, int max) {
        int index = MathUtilities.randomInt(min, max);
        Object pivot = data.get(index);
     
        int i = min;
        int j = max;
     
        // loop invariants
        //     for min <= u < i: data[u] <= pivot
        //     for j < v <= max: pivot <= data[v]
     
        while (i <= j) {
            while (comp.compare(data.get(i), pivot) < 0) i++;
            while (comp.compare(data.get(j), pivot) > 0) j--;
         
            if (i <= j) {
                Object a = data.get(i);   // pivot <= a
                Object b = data.get(j);   // b <= pivot
             
                data.set(i, b);        // now data[i] <= pivot
                data.set(j, a);        // now pivot <= data[j]
             
                i++;                        // so we may do i++
                j--;                        // so we may do j--
            }
        }
     
        // after loop
        //
        // min < i <= max + 1
        // min - 1 <= j < max
        // either i == j + 1 or i == j + 2
        //
        // for min <= u <= j: data[u] <= pivot
        // for i <= v <= max: pivot <= data[v]
        //
        // if i == j + 2 then data[j + 1] == pivot
     
        if (j >= min)
            return j;
        else
            return min; // here j == min-1, i == min+1, data[min] == pivot
    }
	
   
    // test quickSort
    public void testQuickSortArr(){
    	
     	Examples e = new Examples();
     	
     	ArrayList source = new ArrayList();
    		              
     	ArrayList sorted = new ArrayList();
     	ArrayList longunsorted = new ArrayList();
         ArrayList longsorted = new ArrayList();
     	
     	
		source.add(e.duluth1);
		source.add(e.northville);
 		source.add(e.plymouth);
       	
 		sorted.add(e.duluth1);
 		sorted.add(e.northville);
 		sorted.add(e.plymouth);   	
     	

 		longunsorted.add(e.northville);
 		longunsorted.add(e.plymouth); 	
 		longunsorted.add(e.romulus);
 		longunsorted.add(e.duluth1);
 		longunsorted.add(e.gibraltar);
 		longunsorted.add(e.saline);
 		longunsorted.add(e.duluth2);
     	
 		longsorted.add(e.duluth1);
 		longsorted.add(e.duluth2);
 		longsorted.add(e.gibraltar);
 		longsorted.add(e.northville);
 		longsorted.add(e.plymouth);
 		longsorted.add(e.romulus);
 		longsorted.add(e.saline);
     	
     	e.test("quickSort ArrayList", sorted, 
     				     quickSortArr(source, e.byName));
       	
    		e.test("quickSort ArrayList", longsorted, 
    				  		 quickSortArr(longunsorted, e.byName));
    	
    		e.testReport();  	   	   
     }
    
    public static void main(String[] argv){
    	QuickArrSort s = new QuickArrSort();
    		s.testQuickSortArr();
    }
}
    