import java.util.NoSuchElementException;

/* ------------------------------------------------------------------
   Functional (External) Iterator Pattern:
        iterator for a list of cities 
*/

class ListRange implements IRange {

    /*-------------------------------------------------------- 
     Member data
     *------------------------------------------------------*/
    AListOfCities ptr; /* reference to this list */
    
    /*-------------------------------------------------------- 
     Constructor
     *------------------------------------------------------*/
    ListRange(AListOfCities aList) { this.ptr = aList; }
        
    /*--------------------------------------------------------
     Methods to implement the IRange interface
     *------------------------------------------------------*/

    public IRange next() {
    	if (this.hasMore())
		return new ListRange(((ConsListOfCities)this.ptr).rest);
    else
		throw new NoSuchElementException("No next element.");   			
    }


    public Object current() {
    	if (this.hasMore())
        return ((ConsListOfCities)this.ptr).first; 
    	else
    		throw new NoSuchElementException("No current element.");
    }
    
    public boolean hasMore() {
        return (this.ptr instanceof ConsListOfCities); 
    }
    
    /*--------------------------------------------------------
    Method to produce a new ListOf Cities with given city added
    *------------------------------------------------------*/
    
    public AListOfCities addCity(City c){
    		return new ConsListOfCities(c, this.ptr);
    }

    /*--------------------------------------------------------
    Methods to convert the contents to String
    *------------------------------------------------------*/
    
    public String toString(){
    		if (this.hasMore())
    			return "** " + this.current().toString() +
				   this.next().toString();
    		else 
    			return "** end of range **\n";
    }

}
        
