import java.util.*;

public class Examples extends SimpleTestHarness{
		
	City nyc = new City();
	City boston = new City(02115, "Boston", "MA", 78.123345, 40.987654);
	City bos = new City(this.boston);
	
	City northville = new City(48167, "Northville", "MI", 83.479355, 42.426245);
	City pinckney = new City(48169, "Pinckney", "MI", 83.909918, 42.459579);
	City plymouth = new City(48170, "Plymouth", "MI", 83.479946, 42.36882);
	City gibraltar = new City(48173, "Gibraltar", "MI", 83.216196, 42.07918);
	City romulus = new City(48174, "Romulus", "MI", 83.358288, 42.220304);
	City saline = new City(48176, "Saline", "MI", 83.784936, 42.169844);
	City duluth1 = new City(55806, "Duluth", "MN", 92.127871, 46.771457);
	City duluth2 = new City(55807, "Duluth", "MN", 92.169821, 46.740783);
	City duluth3 = new City(55808, "Duluth", "MN", 92.22261, 46.68100);
	
	AListOfCities mtcities = new MTListOfCities();
	AListOfCities cities1 = new ConsListOfCities(this.northville,
			                new ConsListOfCities(this.plymouth,
					        new ConsListOfCities(this.duluth1,
					        		this.mtcities)));
	AListOfCities cities2 = new ConsListOfCities(this.northville,
            				   new ConsListOfCities(this.plymouth,
	                        new ConsListOfCities(this.duluth1,
	        		           this.mtcities)));
	
	ListRange list1 = new ListRange(this.cities1);
	ListRange list2 = new ListRange(this.cities2);
	
	// an instance of the sorting algorithm
	QuickArrSort qs = new QuickArrSort();

	// an instance of the comparator
	Comparator byName = new ByName();	
	
	public void runTests(){
		// used in the constructor for the City
        test("Zip code converter", 12345, this.boston.decimal("12345"));
        test("Zip code converter", 2145, this.boston.decimal("02145"));
        
        // City comparison
        test("Same City", false, this.nyc.same(this.boston));	
        
		// test the test harness
		test("IRange compare", this.cities1, this.cities2);
		

		// tests for all methods used in the insertion sort
		test("QuickSort with 3 items ", new ListRange(new ConsListOfCities(this.duluth1,
				          		    new ConsListOfCities(this.northville,
				          		     new ConsListOfCities(this.plymouth,
				          		      this.mtcities)))),
								   this.qs.sort(this.list1, this.byName));
		
        testReport();
        fullTestReport();
	}
	
}