/*
 * @(#)ConsListOfCities.java  20 February 2003
 */

/**
 * Nonempty list of cities class
 */
public class ConsListOfCities extends AListOfCities{

/*---------------------------------------------------------------
 Member data
 --------------------------------------------------------------*/
    City         first;
    AListOfCities rest;
    
/*---------------------------------------------------------------
 Constructor
 --------------------------------------------------------------*/
    ConsListOfCities (City s, AListOfCities r) {
        this.first = new City(s);
        this.rest  = r;
    }

    /*---------------------------------------------------------------
    Interface ISame
    --------------------------------------------------------------*/
	public boolean sameAListOfCities(AListOfCities alist){
		return alist.sameConsListOfCities(this);
	}
	
	public boolean sameConsListOfCities(ConsListOfCities alist){
		return this.first.same(alist.first) &&
			   this.rest.sameAListOfCities(alist.rest);
	}
/*---------------------------------------------------------------
 Print all member data values.
 --------------------------------------------------------------*/
	public String toString(){
		return("\nnew " + getClass().getName() + "(" + 
					first             + ", " + 
					rest   + ")");
	}
    
}
    
