
import java.util.*;

// functional iterator to traverse an ArrayList structure
public class ArrayListRange implements IRange{
	ArrayList slist;
	int current;
	
	// constructor starting at the given index in the ArrayList
	ArrayListRange(ArrayList slist, int current){
		this.slist = slist;
		if (current >= 0 && current <= slist.size())
			this.current = current;
		else
			throw new NoSuchElementException(
				"Initializing ArrayListRange with current " + current +
				" and ArrayList size " + slist.size() );
	}
	
    /* move the cursor one forward, assuming it is possible */
    public IRange next(){
    		if (this.hasMore())
    			return new ArrayListRange(this.slist, this.current + 1);
    		else
    			throw new NoSuchElementException("No next element.");   			
    }
    
    /* select the item to which the cursor points */
    public Object current(){
    		if (this.hasMore())
    			return this.slist.get(this.current);
    		else
    			throw new NoSuchElementException("No current element.");
    }
    
    /* test whether there are more items in the range */
    public boolean hasMore(){
    		return this.current < slist.size();
    }

    /* produce a new ListOf Cities with given city added */
    public ArrayList addCity(City c){
    		this.slist.add(c);
    		return this.slist;
    }


}