import java.util.Collection;
import java.util.Vector;
import java.util.Comparator;
import java.util.Iterator;

public class Lab8 extends JPFalt {
	/**
	 * Books for test cases.
	 */
	Book b1 = new Book("Joseph Heller", "Catch 22", 1195);
	Book b2 = new Book("Chuck Palahniuk", "Fight Club", 1500);
	Book b3 = new Book("Ayn Rand", "The Fountainhead", 2000);
	Book b4 = new Book("Henry Miller", "Stand Still Like The Hummingbird", 999);
	Book b5 = new Book("Niccolo Machiavelli", "The Prince", 1400);
	
	/** 
	 * For our tests we'll use price for comparision 
	 */
	Container linearContainer = new LinearSearcher(new PriceComparator());
	Container binaryContainer = new BinarySearcher(new PriceComparator());
	Sorter sorter = new Sorter(new PriceComparator());

	/**
	 * A vector of books for test cases. 
	 */
	Vector unsortedBooks = new Vector();
	Vector sortedByPrice = new Vector();

	/** 
	 * Create a test suite 
	 */
	public static void main(String[] args) {
		new Lab8();
	}
	
	/**
	 * Class constructor which sets up  data common to multiple tests.
	 *
	 */
	public Lab8() {
		unsortedBooks.add(b5); 
		unsortedBooks.add(b4);
		unsortedBooks.add(b3); 
		unsortedBooks.add(b2);
		unsortedBooks.add(b1);
		
		sortedByPrice.add(b4);
		sortedByPrice.add(b1);
		sortedByPrice.add(b5);		
		sortedByPrice.add(b2);
		sortedByPrice.add(b3);		
	}
	
	/**
	 * Tests printing the value of a publisher.
	 *
	 */
	public void testPublisherToString() {
		Publisher pub = new Publisher("Springer-Verlag", "Vienna", 1883);
		expected("new Publisher(\"Springer-Verlag\", \"Vienna\", 1883)");
		actual(pub.toString());
	}
	
	/**
	 * Tests linear search of a vector of books. 
	 *
	 * Note: Our testing tool automatically creates buttons to invoke methods
	 * starting with "test" which return void and take no parameters.
	 */
	public void testLinearSearch() {
//		testHeader(/* TODO: Fill in an appropriate test description */);

//		expected(/* TODO: Fill in the value you expect */);
//		actual(/* TODO: Fill in the code to get the actual value of a linear search */ );
	}		
}

class Publisher { 
	String name;
	String location;
	int yearFounded;
	
	/**
	 * Construct a publisher.
	 * 
	 * @param name The company name
	 * @param location The city where the publisher was founded
	 * @param yearFounded The year the publisher was founded
	 */
	Publisher(String name, String location, int yearFounded) {
		this.name = name;
		this.location = location;
		this.yearFounded = yearFounded;
	}
	
	/**
	 * Convert this publisher to a string.
	 * 
	 * Note: We print the value of each field and we use getClass().getName() 
	 * to get the name of the class. What class defines getClass()? Can you 
	 * find it in the javadoc?
	 */
	public String toString() {
		return "new " + getClass().getName() + "(" +
			this.name + ", " +
			this.location + ", " + 
			this.yearFounded + ")";
	}
	
}

class Book {
	String author;
	String title;
	int    price;
	
	/**
	 * Construct a book.
	 * 
	 * @param author The books author
	 * @param title The title
	 * @param price The price of the book in cents.
	 */
	Book(String author, String title, int price) {
		this.author = author;
		this.title = title;
		this.price = price;
	}
}

class PriceComparator implements Comparator {
	/**
	 *  Compare the price of two given books.
	 * 
	 * @param arg0 A book
	 * @param arg1 A book 
	 */	
	public int compare(Object arg0, Object arg1) {
		Book left = (Book)arg0;
		Book right = (Book)arg1;

		if (left.price < right.price) {
			return -1;
		} else if (left.price == right.price) {
			return 0;
		} else {
			return 1;
		}
	}
}

interface Container {
	/**
	 * Tests if the specified object is a component in this vector.
	 * 
	 * @param vector A vector
	 * @param obj An object
	 * @return
	 */
	public boolean contains(Vector vector, Object obj);
}

class LinearSearcher implements Container {
	Comparator comparator;
	
	/**
	 * Construct a linear searcher.
	 * 
	 * @param c A comparator
	 */
	public LinearSearcher(Comparator c) {
		this.comparator = c;
	}
		
	/**
	 * Checks if an object is present in a vector.
	 * 
	 * TODO: Complete this method. Using the methods from the Vector class 
	 * scan the vector for the expected value.
	 * 
	 * Note: Do not use the contains() method in the Vector class.
	 * 
	 * @param v A vector
	 * @param o An object
	 * @return true if the object is present
	 */
	public boolean contains(Vector v, Object o) {
		/* Fill this in */
		return false;
	}
}

class BinarySearcher implements Container {
		Comparator comparator;
	
		/** 
		 * Construct a binary searcher.
		 */
		public BinarySearcher(Comparator c) {
			this.comparator = c;
		}
		

	/**
	 * Checks if an object is present in a vector of ascending elements. 
	 * 
	 * TODO: Complete this method. We have a helper method, consider how 
	 * its used and what are good values for its parameters.
	 * 
	 * @param v Vector which is ascending with respect to the comparator of the class.
	 * @param o The object which may be present
	 * @return true if the object is present
	 */
	public boolean contains(Vector v, Object o) {
		/* Fill this in */
		return false;
	}
	
	/**
	 * Checks if an object is present in a given vector v, in the range v[low] <= v[i] < v[high].
	 * 
	 * TODO: Since this vector is in ascending order, you can check if the given object 
	 * if less than, equal to, or greater than the middle element of the vector. 
	 * If the given object is equal to the middle element, then you are finished, just 
	 * return an appropriate value.  If the given object is less than the middle element, 
	 * then you know all the elements to the left of the middle are less than the given 
	 * object (because the vector is ascending) and you should restrict the interval 
	 * accordingly. 
	 * 
	 * @param v Vector which is ascending with respect to the comparator of the class.
	 * @param obj The object being searched for.
	 * @param low The lower index of the interval.
	 * @param high The upper index of the interval.
	 * @return true If the object is present in the range v[low] <= v[i] < v[high]
	 */
	public boolean searchIn(Vector v, Object obj, int low, int high) {
		/* Fill this in */
		return false;	
	}
}

class Sorter {
	Comparator comparator;
	
	/**
	 * Construct a sorter.
	 * 
	 * @param c A comparator
	 */
	public Sorter(Comparator c) {
		this.comparator = c;
	}
	
	/**
	 * Takes a collection an returns a sorted vector containing the 
	 * same elements in ascending order.
	 * 
	 * TODO: Complete this method.
	 * 
	 * @param c A collection
	 * @return A vector sorted in ascending order with regard to the sorters comparator.
	 */
	public Vector insertionSort(Collection c) {
		/* Fill this in */
		return null;
	}
	
	/**
	 * Inserts an object into a vector in ascending order, so that the 
	 * vector is still ascending after insertion.
	 * 
	 * TODO: Complete this method.
	 * 
	 * @param v A vector
	 * @param o An object
	 */
	public void insert(Vector v, Object o) {
		/* Fill this in */
	}
}
