/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.util;

import java.text.ParseException;

public class Hex {
    private Hex() {
    }

    public static String byteToHex(byte by) {
        return Hex.longToHex(by, 2);
    }

    public static String shortToHex(short s) {
        return Hex.longToHex(s, 4);
    }

    public static String intToHex(int n) {
        return Hex.longToHex(n, 8);
    }

    public static String longToHex(long l) {
        return Hex.longToHex(l, 16);
    }

    public static String floatToHex(float f) {
        return Hex.intToHex(Float.floatToRawIntBits(f));
    }

    public static String doubleToHex(double d) {
        return Hex.longToHex(Double.doubleToRawLongBits(d));
    }

    public static String longToHex(long l, int n) {
        if (n < 1) {
            return "";
        }
        String string = "0123456789ABCDEF";
        char[] cArray = new char[n];
        int n2 = n - 1;
        while (n2 >= 0) {
            cArray[n2] = string.charAt((int)(l & 0xFL));
            l >>>= 4;
            --n2;
        }
        return new String(cArray);
    }

    public static byte hexToByte(String string) throws ParseException {
        return (byte)Hex.hexToLong(string, 2);
    }

    public static short hexToShort(String string) throws ParseException {
        return (short)Hex.hexToLong(string, 4);
    }

    public static int hexToInt(String string) throws ParseException {
        return (int)Hex.hexToLong(string, 8);
    }

    public static long hexToLong(String string) throws ParseException {
        return Hex.hexToLong(string, 16);
    }

    public static float hexToFloat(String string) throws ParseException {
        if (string != null && string.length() != 8) {
            throw new ParseException("Float hex string must have length 8", Math.min(string.length(), 8));
        }
        return Float.intBitsToFloat(Hex.hexToInt(string));
    }

    public static double hexToDouble(String string) throws ParseException {
        if (string != null && string.length() != 16) {
            throw new ParseException("Double hex string must have length 16", Math.min(string.length(), 16));
        }
        return Double.longBitsToDouble(Hex.hexToLong(string));
    }

    public static long hexToLong(String string, int n) throws ParseException {
        if (string == null) {
            throw new ParseException("String is null", 0);
        }
        int n2 = string.length();
        int n3 = 0;
        if (!Hex.isHexString(string)) {
            n3 = 0;
            while (n3 < n2) {
                if (!Hex.isHexDigit(string.charAt(n3))) {
                    throw new ParseException("String is not a hex string", n3);
                }
                ++n3;
            }
        }
        if (n2 > n) {
            throw new ParseException("String is longer than " + n + "digits", n);
        }
        if (n > 16) {
            throw new ParseException("Max digits is larger than 16", 0);
        }
        long l = 0L;
        n3 = 0;
        while (n3 < n2) {
            l <<= 4;
            long l2 = Character.digit(string.charAt(n3), 16);
            l |= l2;
            ++n3;
        }
        return l;
    }

    public static boolean isHexString(String string) {
        if (string == null) {
            return false;
        }
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            if (!Hex.isHexDigit(string.charAt(n2))) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static boolean isHexDigit(char c) {
        return c >= '0' && c <= '9' || c >= 'A' && c <= 'F' || c >= 'a' && c <= 'f';
    }
}

