/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.quick;

import edu.neu.ccs.quick.QuickHashMap;
import edu.neu.ccs.quick.QuickTreeMap;
import edu.neu.ccs.quick.QuickVector;
import edu.neu.ccs.quick.StringObjectPair;

public final class StringObjectMap {
    private QuickTreeMap stringToObjectMap = new QuickTreeMap();
    private QuickHashMap objectToStringMap = new QuickHashMap();
    private QuickVector pairList = new QuickVector();

    public StringObjectMap() {
    }

    public StringObjectMap(Object[][] pairs) {
        this.addPairs(pairs);
    }

    public StringObjectMap(StringObjectPair[] pairs) {
        this.addPairs(pairs);
    }

    public boolean addPair(String string, Object object) {
        return this.addPair(StringObjectPair.makeStringObjectPair(string, object));
    }

    public boolean addPair(StringObjectPair pair) {
        if (pair == null) {
            return false;
        }
        String string = pair.getString();
        if (this.containsString(string)) {
            return false;
        }
        Object object = pair.getObject();
        if (this.containsObject(object)) {
            return false;
        }
        this.stringToObjectMap.put(string, object);
        this.objectToStringMap.put(object, string);
        this.pairList.add(pair);
        return true;
    }

    public boolean addPair(int index, String string, Object object) {
        return this.addPair(index, StringObjectPair.makeStringObjectPair(string, object));
    }

    public boolean addPair(int index, StringObjectPair pair) {
        if (index < 0 || index > this.size()) {
            return false;
        }
        if (pair == null) {
            return false;
        }
        String string = pair.getString();
        if (this.containsString(string)) {
            return false;
        }
        Object object = pair.getObject();
        if (this.containsObject(object)) {
            return false;
        }
        this.stringToObjectMap.put(string, object);
        this.objectToStringMap.put(object, string);
        this.pairList.add(index, pair);
        return true;
    }

    public void addPairs(Object[][] array) {
        this.addPairs(StringObjectPair.toArray(array));
    }

    public void addPairs(StringObjectPair[] pairs) {
        if (pairs == null) {
            return;
        }
        int length = pairs.length;
        int i = 0;
        while (i < length) {
            this.addPair(pairs[i]);
            ++i;
        }
    }

    public void setPairs(Object[][] array) {
        this.clear();
        this.addPairs(array);
    }

    public void setPairs(StringObjectPair[] pairs) {
        this.clear();
        this.addPairs(pairs);
    }

    public StringObjectPair remove(int index) {
        if (index < 0 || index >= this.size()) {
            return null;
        }
        StringObjectPair pair = this.getPair(index);
        String string = pair.getString();
        Object object = pair.getObject();
        this.stringToObjectMap.remove(string);
        this.objectToStringMap.remove(object);
        this.pairList.remove(index);
        return pair;
    }

    public StringObjectPair removeByString(String string) {
        if (!this.containsString(string)) {
            return null;
        }
        Object object = this.getObject(string);
        StringObjectPair pair = new StringObjectPair(string, object);
        this.stringToObjectMap.remove(string);
        this.objectToStringMap.remove(object);
        this.pairList.remove(pair);
        return pair;
    }

    public StringObjectPair removeByObject(Object object) {
        if (!this.containsObject(object)) {
            return null;
        }
        String string = this.getString(object);
        StringObjectPair pair = new StringObjectPair(string, object);
        this.stringToObjectMap.remove(string);
        this.objectToStringMap.remove(object);
        this.pairList.remove(pair);
        return pair;
    }

    public void clear() {
        this.stringToObjectMap.clear();
        this.objectToStringMap.clear();
        this.pairList.clear();
    }

    public int size() {
        return this.pairList.size();
    }

    public String getString(Object object) {
        if (object == null) {
            return null;
        }
        return (String)this.objectToStringMap.get(object);
    }

    public Object getObject(String string) {
        if (string == null) {
            return null;
        }
        return this.stringToObjectMap.get(string);
    }

    public StringObjectPair getPair(int index) {
        if (index < 0 || index >= this.size()) {
            return null;
        }
        return (StringObjectPair)this.pairList.get(index);
    }

    public String getString(int index) {
        StringObjectPair pair = this.getPair(index);
        if (pair == null) {
            return null;
        }
        return pair.getString();
    }

    public Object getObject(int index) {
        StringObjectPair pair = this.getPair(index);
        if (pair == null) {
            return null;
        }
        return pair.getObject();
    }

    public StringObjectPair[] getStringObjectPairs() {
        return this.pairList.toArray(new StringObjectPair[0]);
    }

    public String[] getStrings() {
        return StringObjectPair.getStrings(this.getStringObjectPairs());
    }

    public Object[] getObjects() {
        return StringObjectPair.getObjects(this.getStringObjectPairs());
    }

    public String[] getSortedStrings() {
        return this.stringToObjectMap.keySet().toArray(new String[0]);
    }

    public boolean containsString(String string) {
        if (string == null) {
            return false;
        }
        return this.stringToObjectMap.containsKey(string);
    }

    public boolean containsObject(Object object) {
        if (object == null) {
            return false;
        }
        return this.objectToStringMap.containsKey(object);
    }
}

