/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.jpf;

import edu.neu.ccs.util.MathUtilities;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Arc2D;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import javax.swing.JComponent;

class ActivityIcon {
    protected static Color inputColor = Color.green;
    protected static Color actionColor = Color.yellow;
    protected static Color outputColor = Color.red;
    protected static Color boxColor = Color.black;
    private static int linewidth = 4;
    private static int arrowsize = 4;
    private static int boxsize = 24;
    private static int halfsize = boxsize / 2;
    private static int height = boxsize;

    ActivityIcon() {
    }

    public static class InputIcon
    extends JComponent {
        private int width = ActivityIcon.access$0() + ActivityIcon.access$1();
        private Rectangle2D.Double box = new Rectangle2D.Double();
        private Line2D.Double line = new Line2D.Double();
        private Arc2D.Double arc = new Arc2D.Double();

        public InputIcon() {
            this.setPreferredSize(new Dimension(this.width, height));
        }

        protected void paintComponent(Graphics graphics) {
            int n;
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setStroke(new BasicStroke(linewidth, 1, 1));
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            if (boxColor == null) {
                boxColor = Color.black;
            }
            graphics2D.setPaint(boxColor);
            this.box.setFrame(halfsize, 0.0, boxsize, boxsize);
            graphics2D.fill(this.box);
            if (inputColor == null) {
                inputColor = Color.red;
            }
            graphics2D.setPaint(inputColor);
            int n2 = n = linewidth / 2;
            int n3 = halfsize - linewidth / 2;
            this.line.setLine(n, n2, n, n2 + n3);
            graphics2D.draw(this.line);
            n2 = halfsize;
            int n4 = boxsize - n;
            this.line.setLine(n, n2, n + n4, n2);
            graphics2D.draw(this.line);
            n = boxsize;
            this.line.setLine(n, n2, n - arrowsize, n2 - arrowsize);
            graphics2D.draw(this.line);
            this.line.setLine(n, n2, n - arrowsize, n2 + arrowsize);
            graphics2D.draw(this.line);
        }
    }

    public static class ActionIcon
    extends JComponent {
        private int width = ActivityIcon.access$0();
        private int inset = 2;
        private Rectangle2D.Double box = new Rectangle2D.Double();
        private Line2D.Double line = new Line2D.Double();
        private Arc2D.Double arc = new Arc2D.Double();

        public ActionIcon() {
            this.setPreferredSize(new Dimension(this.width, height));
        }

        protected void paintComponent(Graphics graphics) {
            int n;
            int n2;
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setStroke(new BasicStroke(linewidth, 1, 1));
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            if (boxColor == null) {
                boxColor = Color.black;
            }
            graphics2D.setPaint(boxColor);
            this.box.setFrame(0.0, 0.0, boxsize, boxsize);
            graphics2D.fill(this.box);
            if (actionColor == null) {
                actionColor = Color.yellow;
            }
            graphics2D.setPaint(actionColor);
            int n3 = n2 = boxsize - linewidth - 2 * this.inset;
            int n4 = n = this.inset + linewidth / 2;
            int n5 = 135;
            int n6 = 315;
            this.arc.setArc(n, n4, n2, n3, n5, n6, 0);
            graphics2D.draw(this.arc);
            int n7 = halfsize - n;
            int n8 = (int)Math.round((double)n7 * MathUtilities.sindeg(45.0));
            n4 = n = halfsize - n8;
            this.line.setLine(n, n4, n - arrowsize, n4);
            graphics2D.draw(this.line);
            this.line.setLine(n, n4, n + 1, n4 + arrowsize);
            graphics2D.draw(this.line);
        }
    }

    public static class OutputIcon
    extends JComponent {
        private int width = ActivityIcon.access$0() + ActivityIcon.access$1() + ActivityIcon.access$4();
        private Rectangle2D.Double box = new Rectangle2D.Double();
        private Line2D.Double line = new Line2D.Double();
        private Arc2D.Double arc = new Arc2D.Double();

        public OutputIcon() {
            this.setPreferredSize(new Dimension(this.width, height));
        }

        protected void paintComponent(Graphics graphics) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setStroke(new BasicStroke(linewidth, 1, 1));
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            if (boxColor == null) {
                boxColor = Color.black;
            }
            graphics2D.setPaint(boxColor);
            this.box.setFrame(0.0, 0.0, boxsize, boxsize);
            graphics2D.fill(this.box);
            if (outputColor == null) {
                outputColor = Color.red;
            }
            graphics2D.setPaint(outputColor);
            int n = halfsize;
            int n2 = halfsize;
            int n3 = boxsize - linewidth / 2;
            this.line.setLine(n, n2, n + n3, n2);
            graphics2D.draw(this.line);
            n2 = linewidth / 2;
            int n4 = halfsize - linewidth / 2;
            this.line.setLine(n += n3, n2, n, n2 + n4);
            graphics2D.draw(this.line);
            this.line.setLine(n, n2, n - arrowsize, n2 + arrowsize);
            graphics2D.draw(this.line);
            this.line.setLine(n, n2, n + arrowsize, n2 + arrowsize);
            graphics2D.draw(this.line);
        }
    }
}

