/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.gui;

import edu.neu.ccs.gui.AbsoluteLayout;
import edu.neu.ccs.gui.DisplayPanel;
import edu.neu.ccs.gui.Zoo;
import edu.neu.ccs.gui.ZooGroup;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.util.Vector;
import javax.swing.JComponent;

public class ZooContainer
extends DisplayPanel {
    public ZooContainer() {
        this.setLayout(new AbsoluteLayout());
    }

    public Component addChildItem(Component component) {
        return this.addChildItemImpl(component, 0);
    }

    public Component addChildItem(Component component, int n) {
        return this.addChildItemImpl(component, n);
    }

    public Component findItemAt(int n, int n2) {
        return this.findItemImpl(n, n2, true);
    }

    public Component findItemAt(Point point) {
        return this.findItemImpl(point.x, point.y, true);
    }

    public Component findChildItemAt(int n, int n2) {
        return this.findItemImpl(n, n2, false);
    }

    public Component findChildItemAt(Point point) {
        return this.findItemImpl(point.x, point.y, false);
    }

    public Component getItem(int n) {
        return this.getItems()[n];
    }

    public Component[] getItems() {
        Vector<Component> vector = new Vector<Component>();
        Component component = null;
        ZooGroup zooGroup = null;
        Component[] componentArray = null;
        int n = 0;
        while (n < this.getComponentCount()) {
            component = this.getComponent(n);
            if (component instanceof ZooGroup) {
                zooGroup = (ZooGroup)component;
                componentArray = zooGroup.getItems();
                int n2 = 0;
                while (n2 < componentArray.length) {
                    vector.add(componentArray[n2]);
                    ++n2;
                }
            } else {
                vector.add(component);
            }
            ++n;
        }
        return vector.toArray(new Component[0]);
    }

    public int getItemCount() {
        return this.getItems().length;
    }

    public int inverseGetItem(Component component) {
        Component[] componentArray = this.getItems();
        int n = 0;
        while (n < componentArray.length) {
            if (componentArray[n] == component) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public Component getChildItem(int n) {
        return this.getComponent(n);
    }

    public Component[] getChildItems() {
        return this.getComponents();
    }

    public int getChildItemCount() {
        return this.getComponentCount();
    }

    public int inverseGetChildItem(Component component) {
        Component[] componentArray = this.getChildItems();
        int n = 0;
        while (n < componentArray.length) {
            if (componentArray[n] == component) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public ZooContainer getParentContainer(Component component) {
        Component[] componentArray = this.getChildItems();
        int n = 0;
        while (n < componentArray.length) {
            if (componentArray[n] == component) {
                return this;
            }
            ++n;
        }
        ZooGroup zooGroup = null;
        ZooContainer zooContainer = null;
        int n2 = 0;
        while (n2 < componentArray.length) {
            if (componentArray[n2] instanceof ZooGroup && (zooContainer = (zooGroup = (ZooGroup)componentArray[n2]).getParentContainer(component)) != null) {
                return zooContainer;
            }
            ++n2;
        }
        return null;
    }

    public Zoo getRootZoo() {
        Container container = this;
        while (container != null && container instanceof ZooContainer) {
            container = container.getParent();
        }
        if (container instanceof Zoo) {
            return (Zoo)container;
        }
        return null;
    }

    public Zoo getAncestorZoo() {
        if (this.getRootZoo() == this) {
            return (Zoo)this;
        }
        Container container = this;
        while (container != null) {
            if (!((container = container.getParent()) instanceof Zoo)) continue;
            return (Zoo)container;
        }
        return null;
    }

    public Component removeChildItem(Component component) {
        return this.removeChildItemImpl(component);
    }

    public Component removeChildItem(int n) {
        return this.removeChildItemImpl(this.getChildItem(n));
    }

    public void removeAllItems() {
        this.removeAll();
    }

    public int bringToFront(Component component) {
        return this.moveToZOrder(component, 0);
    }

    public int sendToBack(Component component) {
        return this.moveToZOrder(component, this.getChildItemCount() - 1);
    }

    public int moveUp(Component component) {
        int n = this.inverseGetChildItem(component);
        if (n == -1) {
            return -1;
        }
        int n2 = this.nextHigherInZOrder(n);
        return this.moveToZOrder(component, n2);
    }

    public int moveDown(Component component) {
        int n = this.inverseGetChildItem(component);
        if (n == -1) {
            return -1;
        }
        int n2 = this.nextDeeperInZOrder(n);
        return this.moveToZOrder(component, n2);
    }

    public int moveToZOrder(Component component, int n) {
        if (n < 0 || n > this.getChildItemCount()) {
            throw new ArrayIndexOutOfBoundsException("Z-order is invalid: " + n);
        }
        int n2 = this.inverseGetChildItem(component);
        if (n2 == -1) {
            return -1;
        }
        if (n2 == n) {
            return n2;
        }
        this.removeChildItem(component);
        this.addChildItem(component, n);
        return n;
    }

    public int nextHigherInZOrder(int n) {
        if (n < 0 || n > this.getChildItemCount()) {
            throw new ArrayIndexOutOfBoundsException("Z-order is invalid: " + n);
        }
        Component[] componentArray = this.getChildItems();
        int n2 = n - 1;
        while (n2 > 0) {
            if (componentArray[n2].isVisible() && componentArray[n2].getBounds().intersects(componentArray[n].getBounds())) {
                return n2;
            }
            --n2;
        }
        return 0;
    }

    public int nextDeeperInZOrder(int n) {
        if (n < 0 || n >= this.getChildItemCount()) {
            throw new ArrayIndexOutOfBoundsException("Z-order is invalid: " + n);
        }
        Component[] componentArray = this.getChildItems();
        int n2 = n + 1;
        while (n2 < componentArray.length) {
            if (componentArray[n2].isVisible() && componentArray[n2].getBounds().intersects(componentArray[n].getBounds())) {
                return n2;
            }
            --n2;
        }
        return componentArray.length - 1;
    }

    public ZooGroup group(Component[] componentArray) {
        Vector<Component> vector = new Vector<Component>();
        int n = 0;
        int n2 = Integer.MAX_VALUE;
        int n3 = 0;
        while (n3 < componentArray.length) {
            n = this.inverseGetChildItem(componentArray[n3]);
            if (n > -1) {
                vector.add(componentArray[n3]);
                if (n < n2) {
                    n2 = n;
                }
            }
            ++n3;
        }
        if (vector.size() < 2) {
            return null;
        }
        Component component = n2 == 0 ? null : this.getChildItem(n2 - 1);
        int n4 = 0;
        while (n4 < vector.size()) {
            this.removeChildItem((Component)vector.get(n4));
            ++n4;
        }
        ZooGroup zooGroup = new ZooGroup(vector);
        n2 = component == null ? 0 : this.inverseGetChildItem(component) + 1;
        this.addChildItem(zooGroup, n2);
        return zooGroup;
    }

    public Component[] ungroup(ZooGroup zooGroup) {
        int n = this.inverseGetChildItem(zooGroup);
        if (n == -1) {
            return new Component[0];
        }
        Component component = n == 0 ? null : this.getChildItem(n - 1);
        Component[] componentArray = zooGroup.getComponents();
        this.removeChildItem(zooGroup);
        n = component == null ? 0 : this.inverseGetChildItem(component) + 1;
        int n2 = 0;
        while (n2 < componentArray.length) {
            componentArray[n2].setLocation(componentArray[n2].getX() + zooGroup.getX(), componentArray[n2].getY() + zooGroup.getY());
            this.addChildItem(componentArray[n2], n++);
            ++n2;
        }
        return componentArray;
    }

    public boolean isFocusTraversable() {
        return false;
    }

    public boolean isManagingFocus() {
        return false;
    }

    private Component addChildItemImpl(Component component, int n) {
        if (component == null) {
            return null;
        }
        return this.add(component, n);
    }

    private Component findItemImpl(int n, int n2, boolean bl) {
        if (!this.contains(n, n2)) {
            return null;
        }
        Component[] componentArray = this.getChildItems();
        Component component = this;
        int n3 = 0;
        while (n3 < componentArray.length) {
            if (componentArray[n3].isVisible() && componentArray[n3].contains(n, n2)) {
                component = componentArray[n3];
                if (!bl || !(component instanceof ZooContainer)) break;
                Component component2 = component;
                component = ((Container)component2).findComponentAt(n - ((JComponent)component2).getX(), n2 - ((JComponent)component2).getY());
                break;
            }
            ++n3;
        }
        return component;
    }

    private Component removeChildItemImpl(Component component) {
        Component[] componentArray = this.getChildItems();
        int n = 0;
        while (n < componentArray.length) {
            if (componentArray[n] == component) {
                this.remove(component);
                return component;
            }
            ++n;
        }
        return null;
    }
}

