/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.gui;

import edu.neu.ccs.gui.AbstractPaintable;
import edu.neu.ccs.gui.TextAnchor;
import edu.neu.ccs.gui.TextBounds;
import edu.neu.ccs.gui.TransformFactory;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class TextPaintable
extends AbstractPaintable {
    public static final String SET_STRING = "set.string";
    public static final String SET_FONT = "set.font";
    public static final String SET_FILL_PAINT = "set.fill.paint";
    public static final String SET_ANCHOR_LOCATOR = "set.anchor.locator";
    public static final String SET_ANCHOR_POSITION = "set.anchor.position";
    public static final String SET_BOUNDS_STRATEGY = "set.bounds.strategy";
    public static final FontRenderContext standardFRC = new FontRenderContext(null, true, false);
    private String string = "";
    private Font font = new Font("Serif", 0, 12);
    private Paint fillpaint = Color.black;
    private TextBounds.Strategy strategy = TextBounds.LOOSE;
    private TextAnchor.Locator locator = TextAnchor.LEFT_BASELINE;
    private float anchorX = 0.0f;
    private float anchorY = 0.0f;
    private TextLayout textLayout = null;

    public TextPaintable(String string, Font font, Paint fillpaint, TextBounds.Strategy strategy, TextAnchor.Locator locator, float anchorX, float anchorY) {
        this.setString(string);
        this.setFont(font);
        this.setFillPaint(fillpaint);
        this.setBoundsStrategy(strategy);
        this.setAnchorLocator(locator);
        this.setAnchorPosition(anchorX, anchorY);
    }

    public final void paint(Graphics g) {
        if (this.string.length() == 0 || g == null || !this.isVisible()) {
            return;
        }
        Graphics2D h = this.getPreparedGraphics2D(g);
        h.setFont(this.font);
        h.setPaint(this.fillpaint);
        this.textLayout.draw(h, this.getLeftX(), this.getBaseLineY());
    }

    public TextLayout getTextLayout() {
        return this.textLayout;
    }

    public final Rectangle2D getStringBounds() {
        if (this.string.length() == 0) {
            return new Rectangle2D.Double(this.anchorX, this.anchorY, 0.0, 0.0);
        }
        return this.locator.getBounds2D(this.string, this.font, this.anchorX, this.anchorY);
    }

    public final Rectangle2D getTightBounds() {
        if (this.string.length() == 0) {
            return new Rectangle2D.Double(this.anchorX, this.anchorY, 0.0, 0.0);
        }
        Rectangle2D area = this.textLayout.getBounds();
        float x = (float)area.getX();
        float y = (float)area.getY();
        float w = (float)area.getWidth();
        float h = (float)area.getHeight();
        if (w <= 0.0f || h <= 0.0f) {
            return new Rectangle2D.Double(this.anchorX, this.anchorY, 0.0, 0.0);
        }
        float x0 = this.getLeftX();
        float y0 = this.getBaseLineY();
        area.setRect(x + x0, y + y0, w, h);
        return area;
    }

    public final Rectangle2D getLooseBounds() {
        Rectangle2D area = this.getStringBounds();
        area.add(this.getTightBounds());
        return area;
    }

    public final Rectangle2D getBounds2D() {
        if (this.string.length() == 0) {
            return new Rectangle2D.Double(this.anchorX, this.anchorY, 0.0, 0.0);
        }
        Rectangle2D rectangle = this.getDefaultBounds2D();
        if (rectangle != null) {
            return rectangle;
        }
        return this.strategy.getBounds2D(this);
    }

    public final Point2D getCenter() {
        if (this.string.length() == 0) {
            return new Point2D.Double(this.anchorX, this.anchorY);
        }
        return this.locator.getCenter(this.string, this.font, this.anchorX, this.anchorY);
    }

    public Shape getOutline() {
        return this.string.length() == 0 ? new GeneralPath() : this.textLayout.getOutline(TransformFactory.translate(this.getLeftX(), this.getBaseLineY()));
    }

    public boolean contains(double x, double y) {
        if (!this.possiblyContains(x, y)) {
            return false;
        }
        return this.getOutline().contains(x, y);
    }

    public final void setString(String string) {
        if (string == null || string.equals(this.string)) {
            return;
        }
        this.string = string;
        this.resetTextLayout();
        this.firePropertyChange(SET_STRING, null, null);
    }

    public final String getString() {
        return this.string;
    }

    public final void setFont(Font font) {
        if (font == null || font.equals(this.font)) {
            return;
        }
        this.removeAndAddForwardingListener(this.font, font);
        this.font = font;
        this.resetTextLayout();
        this.firePropertyChange(SET_FONT, null, null);
    }

    public final Font getFont() {
        return this.font;
    }

    public final void setFillPaint(Paint fillpaint) {
        if (fillpaint == null || fillpaint.equals(this.fillpaint)) {
            return;
        }
        this.removeAndAddForwardingListener(this.fillpaint, fillpaint);
        this.fillpaint = fillpaint;
        this.firePropertyChange(SET_FILL_PAINT, null, null);
    }

    public final Paint getFillPaint() {
        return this.fillpaint;
    }

    public final void setBoundsStrategy(TextBounds.Strategy strategy) {
        if (strategy == null || strategy.equals(this.strategy)) {
            return;
        }
        this.strategy = strategy;
        this.firePropertyChange(SET_BOUNDS_STRATEGY, null, null);
    }

    public final TextBounds.Strategy getBoundsStrategy() {
        return this.strategy;
    }

    public final void setAnchorLocator(TextAnchor.Locator locator) {
        if (locator == null || locator.equals(this.locator)) {
            return;
        }
        this.locator = locator;
        this.firePropertyChange(SET_ANCHOR_LOCATOR, null, null);
    }

    public final TextAnchor.Locator getAnchorLocator() {
        return this.locator;
    }

    public final void setAnchorPosition(float anchorX, float anchorY) {
        if (anchorX == this.anchorX && anchorY == this.anchorY) {
            return;
        }
        this.anchorX = anchorX;
        this.anchorY = anchorY;
        this.firePropertyChange(SET_ANCHOR_POSITION, null, null);
    }

    public final void setAnchorPosition(float[] position) {
        if (position == null || position.length != 2) {
            return;
        }
        this.setAnchorPosition(position[0], position[1]);
    }

    public final float[] getAnchorPosition() {
        return new float[]{this.anchorX, this.anchorY};
    }

    public final float getLeftX() {
        if (this.string.length() == 0) {
            return this.anchorX;
        }
        return this.locator.getLeftX(this.string, this.font, this.anchorX);
    }

    public final float getRightX() {
        if (this.string.length() == 0) {
            return this.anchorX;
        }
        return this.locator.getRightX(this.string, this.font, this.anchorX);
    }

    public final float getCenterX() {
        if (this.string.length() == 0) {
            return this.anchorX;
        }
        return this.locator.getCenterX(this.string, this.font, this.anchorX);
    }

    public final float getBaseLineY() {
        if (this.string.length() == 0) {
            return this.anchorY;
        }
        return this.locator.getBaseLineY(this.string, this.font, this.anchorY);
    }

    public final float getAscentLineY() {
        if (this.string.length() == 0) {
            return this.anchorY;
        }
        return this.locator.getAscentLineY(this.string, this.font, this.anchorY);
    }

    public final float getDescentLineY() {
        if (this.string.length() == 0) {
            return this.anchorY;
        }
        return this.locator.getDescentLineY(this.string, this.font, this.anchorY);
    }

    public final float getLeadingLineY() {
        if (this.string.length() == 0) {
            return this.anchorY;
        }
        return this.locator.getLeadingLineY(this.string, this.font, this.anchorY);
    }

    public final float getWidth() {
        return (float)this.getBounds2D().getWidth();
    }

    public final float getHeight() {
        return (float)this.getBounds2D().getHeight();
    }

    private void resetTextLayout() {
        this.textLayout = this.string.length() == 0 ? null : new TextLayout(this.string, this.font, standardFRC);
    }
}

