/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.gui;

import edu.neu.ccs.gui.CellPosition;
import edu.neu.ccs.gui.DisplayPanel;
import edu.neu.ccs.gui.TableGenerator;
import edu.neu.ccs.gui.TableLayout;
import edu.neu.ccs.util.DimensionUtilities;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import javax.swing.JComponent;

public class TablePanel
extends DisplayPanel {
    public static final int DEFAULT_ALIGNMENT = 6;
    public static final int DEFAULT_ORIENTATION = 0;
    protected TableGenerator tg = null;

    public TablePanel() {
        this(1, 1, 0, 0, 6);
    }

    public TablePanel(int n) {
        this(1, 1, 0, 0, n);
    }

    public TablePanel(int n, int n2) {
        this(n, n2, 0, 0, 6);
    }

    public TablePanel(int n, int n2, int n3) {
        this(n, n2, 0, 0, n3);
    }

    public TablePanel(int n, int n2, int n3, int n4) {
        this(n, n2, n3, n4, 6);
    }

    public TablePanel(int n, int n2, int n3, int n4, int n5) {
        this(n, n2, n3, n4, n5, 0);
    }

    public TablePanel(int n, int n2, int n3, int n4, int n5, int n6) {
        super.setLayout(new TableLayout(n, n2, n3, n4, n5, n6));
        this.resetPreferredSize();
    }

    public TablePanel(Object[] objectArray, int n) {
        this(objectArray, n, 0, 0, 6);
    }

    public TablePanel(Object[] objectArray, int n, int n2) {
        this(objectArray, n, 0, 0, n2);
    }

    public TablePanel(Object[] objectArray, int n, int n2, int n3) {
        this(objectArray, n, n2, n3, 6);
    }

    public TablePanel(Object[] objectArray, int n, int n2, int n3, int n4) {
        if (objectArray == null || objectArray.length == 0) {
            super.setLayout(new TableLayout(1, 1, n2, n3, n4, n));
            return;
        }
        int n5 = objectArray.length;
        if (n == 1) {
            super.setLayout(new TableLayout(n5, 1, n2, n3, n4, n));
            int n6 = 0;
            while (n6 < n5) {
                this.addObject(objectArray[n6], n6, 0);
                ++n6;
            }
        } else {
            super.setLayout(new TableLayout(1, n5, n2, n3, n4, n));
            int n7 = 0;
            while (n7 < n5) {
                this.addObject(objectArray[n7], 0, n7);
                ++n7;
            }
        }
        this.resetPreferredSize();
    }

    public TablePanel(Object[][] objectArray) {
        this(objectArray, 0, 0, 6);
    }

    public TablePanel(Object[][] objectArray, int n) {
        this(objectArray, 0, 0, n);
    }

    public TablePanel(Object[][] objectArray, int n, int n2) {
        this(objectArray, n, n2, 6);
    }

    public TablePanel(Object[][] objectArray, int n, int n2, int n3) {
        if (objectArray == null || objectArray.length == 0) {
            super.setLayout(new TableLayout(1, 1, n, n2, n3, 1));
            return;
        }
        int n4 = objectArray.length;
        int n5 = 0;
        int n6 = 0;
        while (n6 < n4) {
            if (objectArray[n6] != null) {
                n5 = Math.max(n5, objectArray[n6].length);
            }
            ++n6;
        }
        if (n5 == 0) {
            super.setLayout(new TableLayout(1, 1, n, n2, n3, 1));
            return;
        }
        super.setLayout(new TableLayout(n4, n5, n, n2, n3, 1));
        int n7 = 0;
        while (n7 < n4) {
            if (objectArray[n7] != null) {
                n5 = objectArray[n7].length;
                int n8 = 0;
                while (n8 < n5) {
                    this.addObject(objectArray[n7][n8], n7, n8);
                    ++n8;
                }
            }
            ++n7;
        }
        this.resetPreferredSize();
    }

    public TablePanel(TableGenerator tableGenerator, int n, int n2) {
        this(tableGenerator, n, n2, 0, 0, 6);
    }

    public TablePanel(TableGenerator tableGenerator, int n, int n2, int n3) {
        this(tableGenerator, n, n2, 0, 0, n3);
    }

    public TablePanel(TableGenerator tableGenerator, int n, int n2, int n3, int n4) {
        this(tableGenerator, n, n2, n3, n4, 6);
    }

    public TablePanel(TableGenerator tableGenerator, int n, int n2, int n3, int n4, int n5) {
        super.setLayout(new TableLayout(n, n2, n3, n4, n5));
        this.tg = tableGenerator;
        this.createCells(0, 0, n, n2);
        this.resetPreferredSize();
    }

    public Component addObject(Object object, int n, int n2) {
        return this.addObject(object, new CellPosition(n, n2));
    }

    public Component[][] getComponentTable() {
        return this.getTableLayout().getComponentTable();
    }

    public TableGenerator getTableGenerator() {
        return this.tg;
    }

    public Component getTableEntry(int n, int n2) {
        if (this.isValidRow(n) && this.isValidColumn(n2)) {
            Component[][] componentArray = this.getComponentTable();
            return componentArray[n][n2];
        }
        return null;
    }

    public Component getTableEntry(CellPosition cellPosition) {
        if (cellPosition != null) {
            return this.getTableEntry(cellPosition.row, cellPosition.col);
        }
        return null;
    }

    public void setRows(int n) {
        int n2 = this.getRowCount();
        if (n < 0 || n == n2) {
            return;
        }
        int n3 = this.getColumnCount();
        if (n2 < n) {
            this.getTableLayout().setRows(n);
            this.createCells(n2, 0, n, n3);
        } else {
            this.removeCells(n, 0, n2, n3);
            this.getTableLayout().setRows(n);
        }
        this.resetPreferredSize();
    }

    public void setColumns(int n) {
        int n2 = this.getColumnCount();
        if (n < 0 || n == n2) {
            return;
        }
        int n3 = this.getRowCount();
        if (n2 < n) {
            this.getTableLayout().setColumns(n);
            this.createCells(0, n2, n3, n);
        } else {
            this.removeCells(0, n, n3, n2);
            this.getTableLayout().setColumns(n);
        }
        this.resetPreferredSize();
    }

    public int getRowCount() {
        return this.getTableLayout().getRowCount();
    }

    public int getColumnCount() {
        return this.getTableLayout().getColumnCount();
    }

    public boolean isValidRow(int n) {
        return this.getTableLayout().isValidRow(n);
    }

    public boolean isValidColumn(int n) {
        return this.getTableLayout().isValidColumn(n);
    }

    public boolean isEmptyRow(int n) {
        return this.getTableLayout().isEmptyRow(n);
    }

    public boolean isEmptyColumn(int n) {
        return this.getTableLayout().isEmptyColumn(n);
    }

    public void setHorizontalGap(int n) {
        this.getTableLayout().setHorizontalGap(n);
        this.resetPreferredSize();
    }

    public int getHorizontalGap() {
        return this.getTableLayout().getHorizontalGap();
    }

    public void setVerticalGap(int n) {
        this.getTableLayout().setVerticalGap(n);
        this.resetPreferredSize();
    }

    public int getVerticalGap() {
        return this.getTableLayout().getVerticalGap();
    }

    public void setOrientation(int n) {
        this.getTableLayout().setOrientation(n);
    }

    public int getOrientation() {
        return this.getTableLayout().getOrientation();
    }

    public void setTableAlignment(int n) {
        this.getTableLayout().setTableAlignment(n);
        this.refresh();
    }

    public int getTableAlignment() {
        return this.getTableLayout().getTableAlignment();
    }

    public void setRowAlignment(int n, int n2) {
        this.getTableLayout().setRowAlignment(n, n2);
        this.refresh();
    }

    public int getRowAlignment(int n) {
        return this.getTableLayout().getRowAlignment(n);
    }

    public void setColumnAlignment(int n, int n2) {
        this.getTableLayout().setColumnAlignment(n, n2);
        this.refresh();
    }

    public int getColumnAlignment(int n) {
        return this.getTableLayout().getColumnAlignment(n);
    }

    public void setCellAlignment(CellPosition cellPosition, int n) {
        if (cellPosition != null) {
            this.setCellAlignment(cellPosition.row, cellPosition.col, n);
        }
    }

    public void setCellAlignment(int n, int n2, int n3) {
        this.getTableLayout().setCellAlignment(n, n2, n3);
        this.refresh();
    }

    public int getCellAlignment(CellPosition cellPosition) {
        return this.getTableLayout().getCellAlignment(cellPosition);
    }

    public int getCellAlignment(int n, int n2) {
        return this.getTableLayout().getCellAlignment(n, n2);
    }

    public int getEffectiveCellAlignment(CellPosition cellPosition) {
        return this.getTableLayout().getEffectiveCellAlignment(cellPosition);
    }

    public int getEffectiveCellAlignment(int n, int n2) {
        return this.getTableLayout().getEffectiveCellAlignment(n, n2);
    }

    public void setMinimumRowHeight(int n, int n2) {
        this.getTableLayout().setMinimumRowHeight(n, n2);
        this.resetPreferredSize();
    }

    public int getMinimumRowHeight(int n) {
        return this.getTableLayout().getMinimumRowHeight(n);
    }

    public void setMinimumColumnWidth(int n, int n2) {
        this.getTableLayout().setMinimumColumnWidth(n, n2);
        this.resetPreferredSize();
    }

    public int getMinimumColumnWidth(int n) {
        return this.getTableLayout().getMinimumColumnWidth(n);
    }

    public void setAllMinimumRowHeights(int n) {
        this.getTableLayout().setAllMinimumRowHeights(n);
        this.resetPreferredSize();
    }

    public void setAllMinimumColumnWidths(int n) {
        this.getTableLayout().setAllMinimumColumnWidths(n);
        this.resetPreferredSize();
    }

    public TableLayout getTableLayout() {
        return (TableLayout)this.getLayout();
    }

    public void setLayout(LayoutManager layoutManager) {
    }

    public Dimension getMinimumSize() {
        return this.getTableLayout().minimumLayoutSize(this);
    }

    public Dimension getPreferredSize() {
        return this.getTableLayout().preferredLayoutSize(this);
    }

    public Dimension getMaximumSize() {
        return this.getTableLayout().maximumLayoutSize(this);
    }

    public void uniformizeCellSize() {
        Component[] componentArray = this.getComponents();
        int n = componentArray.length;
        JComponent jComponent = null;
        Dimension dimension = new Dimension();
        int n2 = 0;
        while (n2 < n) {
            if (componentArray[n2] instanceof JComponent) {
                jComponent = (JComponent)componentArray[n2];
                dimension = DimensionUtilities.max(dimension, jComponent.getPreferredSize());
            }
            ++n2;
        }
        this.setAllMinimumColumnWidths((int)dimension.getWidth());
        this.setAllMinimumRowHeights((int)dimension.getHeight());
    }

    public void uniformizeCellWidth() {
        Component[] componentArray = this.getComponents();
        int n = componentArray.length;
        JComponent jComponent = null;
        Dimension dimension = null;
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            if (componentArray[n3] instanceof JComponent) {
                jComponent = (JComponent)componentArray[n3];
                dimension = jComponent.getPreferredSize();
                n2 = Math.max(n2, (int)dimension.getWidth());
            }
            ++n3;
        }
        this.setAllMinimumColumnWidths(n2);
    }

    public void uniformizeCellHeight() {
        Component[] componentArray = this.getComponents();
        int n = componentArray.length;
        JComponent jComponent = null;
        Dimension dimension = null;
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            if (componentArray[n3] instanceof JComponent) {
                jComponent = (JComponent)componentArray[n3];
                dimension = jComponent.getPreferredSize();
                n2 = Math.max(n2, (int)dimension.getHeight());
            }
            ++n3;
        }
        this.setAllMinimumRowHeights(n2);
    }

    protected void createCells(int n, int n2, int n3, int n4) {
        if (this.tg == null) {
            return;
        }
        int n5 = n;
        while (n5 < n3) {
            int n6 = n2;
            while (n6 < n4) {
                this.addObject(this.tg.makeContents(n5, n6), n5, n6);
                ++n6;
            }
            ++n5;
        }
    }

    protected void removeCells(int n, int n2, int n3, int n4) {
        Component[][] componentArray = this.getComponentTable();
        Component component = null;
        CellPosition cellPosition = new CellPosition();
        int n5 = n;
        while (n5 < n3) {
            int n6 = n2;
            while (n6 < n4) {
                component = componentArray[n5][n6];
                if (component != null) {
                    this.remove(component);
                }
                ++n6;
            }
            ++n5;
        }
    }

    protected void resetPreferredSize() {
        this.setPreferredSize(this.getPreferredSize());
        this.refresh();
    }

    protected void refresh() {
        this.revalidate();
        this.repaint();
    }
}

