/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.gui;

import edu.neu.ccs.gui.StringObjectView;
import edu.neu.ccs.quick.StringObjectMap;
import edu.neu.ccs.quick.StringObjectPair;
import java.awt.Dimension;
import javax.swing.Action;
import javax.swing.JComboBox;

public class StringObjectDropdown
extends JComboBox
implements StringObjectView {
    public static final int DEFAULT_WIDTH = 200;
    protected StringObjectMap map = null;
    protected boolean sort = false;

    public StringObjectDropdown() {
        this.initializeSODropdown(null, null, -1, false);
    }

    public StringObjectDropdown(Object[][] pairs) {
        this.initializeSODropdown(StringObjectPair.toArray(pairs), null, -1, false);
    }

    public StringObjectDropdown(Object[][] pairs, Action action) {
        this.initializeSODropdown(StringObjectPair.toArray(pairs), action, -1, false);
    }

    public StringObjectDropdown(Object[][] pairs, Action action, int width) {
        this.initializeSODropdown(StringObjectPair.toArray(pairs), action, width, false);
    }

    public StringObjectDropdown(Object[][] pairs, Action action, int width, boolean sort) {
        this.initializeSODropdown(StringObjectPair.toArray(pairs), action, width, sort);
    }

    public StringObjectDropdown(StringObjectPair[] pairs) {
        this.initializeSODropdown(pairs, null, -1, false);
    }

    public StringObjectDropdown(StringObjectPair[] pairs, Action action) {
        this.initializeSODropdown(pairs, action, -1, false);
    }

    public StringObjectDropdown(StringObjectPair[] pairs, Action action, int width) {
        this.initializeSODropdown(pairs, action, width, false);
    }

    public StringObjectDropdown(StringObjectPair[] pairs, Action action, int width, boolean sort) {
        this.initializeSODropdown(pairs, action, width, sort);
    }

    public StringObjectDropdown(StringObjectMap map) {
        StringObjectPair[] pairs = map == null ? null : map.getStringObjectPairs();
        this.initializeSODropdown(pairs, null, -1, false);
    }

    public StringObjectDropdown(StringObjectMap map, Action action) {
        StringObjectPair[] pairs = map == null ? null : map.getStringObjectPairs();
        this.initializeSODropdown(pairs, action, -1, false);
    }

    public StringObjectDropdown(StringObjectMap map, Action action, int width) {
        StringObjectPair[] pairs = map == null ? null : map.getStringObjectPairs();
        this.initializeSODropdown(pairs, action, width, false);
    }

    public StringObjectDropdown(StringObjectMap map, Action action, int width, boolean sort) {
        StringObjectPair[] pairs = map == null ? null : map.getStringObjectPairs();
        this.initializeSODropdown(pairs, action, width, sort);
    }

    protected final void initializeSODropdown(StringObjectPair[] pairs, Action action, int width, boolean sort) {
        this.map = new StringObjectMap(pairs);
        this.sort = sort;
        String[] strings = sort ? this.map.getSortedStrings() : this.map.getStrings();
        int length = strings.length;
        int i = 0;
        while (i < length) {
            this.addItem(strings[i]);
            ++i;
        }
        this.setPreferredWidth(width);
        if (action != null) {
            this.addActionListener(action);
        }
    }

    public final String getSelectedString() {
        return (String)this.getSelectedItem();
    }

    public final Object getSelectedObject() {
        return this.map.getObject(this.getSelectedString());
    }

    public final void setSelectedString(String string) {
        if (!this.map.containsString(string)) {
            return;
        }
        String oldString = this.getSelectedString();
        if (string.equals(oldString)) {
            return;
        }
        this.setSelectedItem(string);
        this.firePropertyChange("view.state", oldString, string);
    }

    public final void setSelectedObject(Object object) {
        this.setSelectedString(this.map.getString(object));
    }

    public final void setPreferredWidth(int width) {
        if (width < 0) {
            return;
        }
        if (width == 0) {
            width = 200;
        }
        this.setPreferredSize(new Dimension(width, this.getPreferredSize().height));
    }

    public final void setPairs(Object[][] pairs) {
        this.removeAllItems();
        this.initializeSODropdown(StringObjectPair.toArray(pairs), null, -1, this.sort);
    }

    public final void setPairs(StringObjectPair[] pairs) {
        this.removeAllItems();
        this.initializeSODropdown(pairs, null, -1, this.sort);
    }

    public final void setPairs(StringObjectMap map) {
        this.removeAllItems();
        this.initializeSODropdown(map.getStringObjectPairs(), null, -1, this.sort);
    }
}

