/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.gui;

import edu.neu.ccs.Stringable;
import edu.neu.ccs.filter.FilterException;
import edu.neu.ccs.filter.StringableFilter;
import edu.neu.ccs.gui.CancelledException;
import edu.neu.ccs.gui.ErrorDialog;
import edu.neu.ccs.gui.GeneralView;
import edu.neu.ccs.gui.InputProperties;
import edu.neu.ccs.gui.MalformedDataEvent;
import edu.neu.ccs.gui.MalformedDataListener;
import edu.neu.ccs.util.JPTConstants;
import edu.neu.ccs.util.StringableFactory;
import java.awt.Component;
import java.text.ParseException;
import javax.swing.JComponent;
import javax.swing.event.EventListenerList;

public class GeneralViewSupport
implements JPTConstants {
    public static final String VIEW_STATE = "view.state";
    public static final String DEFAULT_VIEW_STATE = "default.view.state";
    public static final String DATA_TYPE = "data.type";
    public static final String FILTER = "filter";
    private GeneralView view = null;
    private EventListenerList listenerList = null;
    private JComponent component = null;
    private StringableFactory factory = new StringableFactory(class$edu$neu$ccs$XString != null ? class$edu$neu$ccs$XString : (class$edu$neu$ccs$XString = GeneralViewSupport.class$("edu.neu.ccs.XString")));
    private InputProperties properties = new InputProperties();
    private StringableFilter filter = null;
    private String defaultViewState = "";
    static /* synthetic */ Class class$edu$neu$ccs$XString;
    static /* synthetic */ Class class$edu$neu$ccs$gui$MalformedDataListener;

    public GeneralViewSupport(GeneralView view, EventListenerList listenerList, Class dataType, String errorPrompt, String dialogTitle, String suggestion) {
        if (view == null || listenerList == null) {
            throw new NullPointerException("Invalid null parameter to GeneralViewSupport constructor");
        }
        if (!(view instanceof JComponent)) {
            throw new IllegalArgumentException("View in GeneralViewSupport constructor is not JComponent");
        }
        this.view = view;
        this.listenerList = listenerList;
        this.component = (JComponent)((Object)view);
        this.setDataType(dataType);
        this.setErrorPromptTitleSuggestion(errorPrompt, dialogTitle, suggestion);
    }

    public GeneralView getView() {
        return this.view;
    }

    public void setDataType(Class dataType) {
        Class oldType = this.getDataType();
        this.factory.setDataType(dataType);
        if (oldType != this.getDataType()) {
            this.component.firePropertyChange(DATA_TYPE, 0, 1);
        }
    }

    public Class getDataType() {
        return this.factory.getDataType();
    }

    public void setFilter(StringableFilter filter) {
        StringableFilter oldFilter = this.getFilter();
        this.filter = filter;
        if (filter != oldFilter) {
            this.component.firePropertyChange(FILTER, 0, 1);
        }
    }

    public StringableFilter getFilter() {
        return this.filter;
    }

    public Stringable obtainObject(Stringable object) throws ParseException {
        block5: {
            if (object == null) {
                throw new ParseException("Null object in obtainObject", -1);
            }
            try {
                object.fromStringData(this.view.getViewState());
                if (this.filter == null) break block5;
                try {
                    object = this.filter.filterStringable(object);
                }
                catch (FilterException ex) {
                    throw new ParseException(ex.getMessage(), -1);
                }
            }
            catch (NumberFormatException ex) {
                throw new ParseException(ex.getMessage(), -1);
            }
        }
        return object;
    }

    public Stringable demandObject() {
        Stringable object = this.factory.getDefaultInstance();
        try {
            object = this.obtainObject(object);
        }
        catch (ParseException ex) {
            this.handleError(object, 0, ex);
            this.view.setViewState(object.toStringData());
            this.component.repaint();
        }
        return object;
    }

    public Stringable requestObject() throws CancelledException {
        Stringable object = this.factory.getDefaultInstance();
        try {
            object = this.obtainObject(object);
        }
        catch (ParseException ex) {
            if (!this.handleError(object, 1, ex)) {
                throw new CancelledException();
            }
            this.view.setViewState(object.toStringData());
            this.component.repaint();
        }
        return object;
    }

    public Stringable demandObject(StringableFilter filter) {
        StringableFilter oldFilter = this.getFilter();
        this.setFilter(filter);
        Stringable object = this.demandObject();
        this.setFilter(oldFilter);
        return object;
    }

    public Stringable requestObject(StringableFilter filter) throws CancelledException {
        StringableFilter oldFilter = this.getFilter();
        this.setFilter(filter);
        Stringable object = null;
        try {
            object = this.requestObject();
        }
        finally {
            Object var5_4 = null;
            this.setFilter(oldFilter);
        }
        return object;
    }

    public Stringable demandObject(Class dataType, StringableFilter filter) {
        Class oldClass = this.factory.getDataType();
        this.factory.setDataType(dataType);
        StringableFilter oldFilter = this.getFilter();
        this.setFilter(filter);
        Stringable object = this.demandObject();
        this.factory.setDataType(oldClass);
        this.setFilter(oldFilter);
        return object;
    }

    public Stringable requestObject(Class dataType, StringableFilter filter) throws CancelledException {
        Class oldClass = this.factory.getDataType();
        this.factory.setDataType(dataType);
        StringableFilter oldFilter = this.getFilter();
        this.setFilter(filter);
        Stringable object = null;
        try {
            object = this.requestObject();
        }
        finally {
            Object var7_6 = null;
            this.factory.setDataType(oldClass);
            this.setFilter(oldFilter);
        }
        return object;
    }

    public void setInputProperties(InputProperties properties) {
        if (properties == null) {
            properties = InputProperties.BASE_PROPERTIES;
        }
        InputProperties oldProperties = this.getInputProperties();
        this.properties = properties;
        if (properties != null && !properties.equals(oldProperties)) {
            this.component.firePropertyChange("input.properties", 0, 1);
        }
    }

    public InputProperties getInputProperties() {
        return this.properties;
    }

    public void setErrorPromptTitleSuggestion(String errorPrompt, String dialogTitle, String suggestion) {
        this.properties.setInputPrompt(errorPrompt);
        this.properties.setDialogTitle(dialogTitle);
        this.properties.setSuggestion(suggestion);
    }

    public void setDefaultViewState(String data) {
        String oldDefaultViewState = this.defaultViewState;
        this.defaultViewState = data = data == null ? "" : data;
        if (!oldDefaultViewState.equals(this.defaultViewState)) {
            this.component.firePropertyChange(DEFAULT_VIEW_STATE, 0, 1);
        }
    }

    public String getDefaultViewState() {
        return this.defaultViewState;
    }

    public void reset() {
        this.view.setViewState(this.getDefaultViewState());
    }

    public void addMalformedDataListener(MalformedDataListener l) {
        this.listenerList.add(class$edu$neu$ccs$gui$MalformedDataListener != null ? class$edu$neu$ccs$gui$MalformedDataListener : (class$edu$neu$ccs$gui$MalformedDataListener = GeneralViewSupport.class$("edu.neu.ccs.gui.MalformedDataListener")), l);
    }

    public void removeMalformedDataListener(MalformedDataListener l) {
        this.listenerList.remove(class$edu$neu$ccs$gui$MalformedDataListener != null ? class$edu$neu$ccs$gui$MalformedDataListener : (class$edu$neu$ccs$gui$MalformedDataListener = GeneralViewSupport.class$("edu.neu.ccs.gui.MalformedDataListener")), l);
    }

    protected boolean handleError(Stringable object, int inputModel, ParseException exception) {
        this.fireDataMalformed(new MalformedDataEvent(this.view, this.view.getViewState(), exception));
        InputProperties errorProperties = new InputProperties(this.properties);
        if (inputModel != 1) {
            inputModel = 0;
        }
        errorProperties.setInputModel(inputModel);
        GeneralView copy = this.view.makeCopy();
        copy.setInputProperties(errorProperties);
        ErrorDialog dialog = new ErrorDialog(object, copy, this.filter, exception);
        ((Component)dialog).setVisible(true);
        this.fireDataMalformed(new MalformedDataEvent((Object)this.view, this.view.getViewState()));
        return dialog.wasCancelled() ^ true;
    }

    protected void fireDataMalformed(MalformedDataEvent event) {
        Object[] objects = this.listenerList.getListenerList();
        int i = objects.length - 2;
        while (i >= 0) {
            if (objects[i] != null && objects[i].equals(class$edu$neu$ccs$gui$MalformedDataListener != null ? class$edu$neu$ccs$gui$MalformedDataListener : GeneralViewSupport.class$("edu.neu.ccs.gui.MalformedDataListener"))) {
                MalformedDataListener listener = (MalformedDataListener)objects[i + 1];
                listener.dataMalformed(event);
            }
            i -= 2;
        }
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }
}

