/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.gui;

import edu.neu.ccs.gui.AbstractPaintable;
import edu.neu.ccs.gui.Paintable;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class ClippingWrapper
extends AbstractPaintable {
    public static final String SET_PAINTABLE = "set.paintable";
    public static final String SET_CLIPPING_SHAPE = "set.clipping.shape";
    private Paintable paintable = null;
    private Shape clippingshape = null;

    public ClippingWrapper() {
    }

    public ClippingWrapper(Paintable paintable) {
        this.setPaintable(paintable);
    }

    public ClippingWrapper(Paintable paintable, Shape clippingshape) {
        this.setPaintable(paintable);
        this.setClippingShape(clippingshape);
    }

    public final void paint(Graphics g) {
        if (this.paintable == null || g == null || !this.isVisible()) {
            return;
        }
        Graphics2D h = this.getPreparedGraphics2D(g);
        if (this.clippingshape != null) {
            h.clip(this.clippingshape);
        }
        this.paintable.paint(h);
    }

    public final void setPaintable(Paintable paintable) {
        if (paintable == this.paintable) {
            return;
        }
        this.removeAndAddForwardingListener(this.paintable, paintable);
        this.paintable = paintable;
        this.firePropertyChange(SET_PAINTABLE, null, null);
    }

    public final Paintable getPaintable() {
        return this.paintable;
    }

    public final void setClippingShape(Shape clippingshape) {
        if (clippingshape == this.clippingshape) {
            return;
        }
        this.removeAndAddForwardingListener(this.clippingshape, clippingshape);
        this.clippingshape = clippingshape;
        this.firePropertyChange(SET_CLIPPING_SHAPE, null, null);
    }

    public final Shape getClippingShape() {
        return this.clippingshape;
    }

    public final Rectangle2D getBounds2D() {
        if (this.paintable == null) {
            return new Rectangle2D.Double();
        }
        Rectangle2D rectangle = this.getDefaultBounds2D();
        if (rectangle != null) {
            return rectangle;
        }
        rectangle = this.paintable.getBounds2D();
        if (this.clippingshape != null) {
            Rectangle2D clippingbounds = this.clippingshape.getBounds2D();
            rectangle = rectangle.createIntersection(clippingbounds);
            double x = rectangle.getX();
            double y = rectangle.getY();
            double w = rectangle.getWidth();
            double h = rectangle.getHeight();
            if (w <= 0.0 || h <= 0.0) {
                rectangle.setRect(x, y, 0.0, 0.0);
            }
        }
        return rectangle;
    }

    public final Point2D getCenter() {
        if (this.paintable == null) {
            return new Point2D.Double();
        }
        Point2D center = this.getDefaultCenter();
        if (center != null) {
            return center;
        }
        return this.paintable.getCenter();
    }

    public final boolean contains(double x, double y) {
        if (this.paintable == null || !this.possiblyContains(x, y)) {
            return false;
        }
        if (this.clippingshape == null) {
            return this.paintable.contains(x, y);
        }
        return this.paintable.contains(x, y) && this.clippingshape.contains(x, y);
    }
}

