/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.filter;

import edu.neu.ccs.Stringable;
import edu.neu.ccs.XNumber;
import edu.neu.ccs.filter.BoundFilter;
import edu.neu.ccs.filter.FilterException;

public class MaximumBoundFilter
extends BoundFilter {
    public static final String MAXIMUM = "maximum";

    public MaximumBoundFilter(boolean bl) {
        super(bl);
    }

    public static class Long
    extends MaximumBoundFilter {
        protected long maximum = 0L;

        public Long(long l) {
            this(l, true);
        }

        public Long(long l, boolean bl) {
            super(bl);
            this.setMaximum(l);
        }

        public Stringable filterStringable(Stringable stringable) throws FilterException {
            XNumber xNumber = (XNumber)super.filterStringable(stringable);
            long l = xNumber.longValue();
            if (l < this.getMaximum() || this.isInclusive() && l == this.getMaximum()) {
                return stringable;
            }
            String string = "Value not within the range [inf. ,";
            string = String.valueOf(string) + this.getMaximum() + (super.isInclusive() ? "]" : ")");
            throw new FilterException(stringable, string);
        }

        public void setMaximum(long l) {
            long l2 = this.getMaximum();
            this.maximum = l;
            if (this.getMaximum() != l2) {
                this.changeAdapter.firePropertyChange(MaximumBoundFilter.MAXIMUM, new java.lang.Long(l2), new java.lang.Long(this.getMaximum()));
            }
        }

        public long getMaximum() {
            return this.maximum;
        }
    }

    public static class Double
    extends MaximumBoundFilter {
        protected double maximum = 0.0;

        public Double(double d) {
            this(d, true);
        }

        public Double(double d, boolean bl) {
            super(bl);
            this.setMaximum(d);
        }

        public Stringable filterStringable(Stringable stringable) throws FilterException {
            XNumber xNumber = (XNumber)super.filterStringable(stringable);
            double d = xNumber.doubleValue();
            if (d < this.getMaximum() || this.isInclusive() && d == this.getMaximum()) {
                return stringable;
            }
            String string = "Value not within the range [inf. ,";
            string = String.valueOf(string) + this.getMaximum() + (super.isInclusive() ? "]" : ")");
            throw new FilterException(stringable, string);
        }

        public void setMaximum(double d) {
            double d2 = this.getMaximum();
            this.maximum = d;
            if (this.getMaximum() != d2) {
                this.changeAdapter.firePropertyChange(MaximumBoundFilter.MAXIMUM, new java.lang.Double(d2), new java.lang.Double(this.getMaximum()));
            }
        }

        public double getMaximum() {
            return this.maximum;
        }
    }

    public static class BigInteger
    extends MaximumBoundFilter {
        protected java.math.BigInteger maximum = null;

        public BigInteger(java.math.BigInteger bigInteger) {
            this(bigInteger, true);
        }

        public BigInteger(java.math.BigInteger bigInteger, boolean bl) {
            super(bl);
            this.setMaximum(bigInteger);
        }

        public Stringable filterStringable(Stringable stringable) throws FilterException {
            XNumber xNumber = (XNumber)super.filterStringable(stringable);
            java.math.BigInteger bigInteger = new java.math.BigInteger(new java.lang.Long(xNumber.longValue()).toString());
            if (bigInteger.compareTo(this.getMaximum()) < 0 || this.isInclusive() && bigInteger.compareTo(this.getMaximum()) == 0) {
                return stringable;
            }
            String string = "Value not within the range [inf. ,";
            string = String.valueOf(string) + this.getMaximum() + (super.isInclusive() ? "]" : ")");
            throw new FilterException(stringable, string);
        }

        public void setMaximum(java.math.BigInteger bigInteger) {
            if (bigInteger == null) {
                return;
            }
            java.math.BigInteger bigInteger2 = this.getMaximum();
            this.maximum = bigInteger;
            if (!this.getMaximum().equals(bigInteger2)) {
                this.changeAdapter.firePropertyChange(MaximumBoundFilter.MAXIMUM, bigInteger2, this.getMaximum());
            }
        }

        public java.math.BigInteger getMaximum() {
            return this.maximum;
        }
    }

    public static class BigDecimal
    extends MaximumBoundFilter {
        protected java.math.BigDecimal maximum = null;

        public BigDecimal(java.math.BigDecimal bigDecimal) {
            this(bigDecimal, true);
        }

        public BigDecimal(java.math.BigDecimal bigDecimal, boolean bl) {
            super(bl);
            this.setMaximum(bigDecimal);
        }

        public Stringable filterStringable(Stringable stringable) throws FilterException {
            XNumber xNumber = (XNumber)super.filterStringable(stringable);
            java.math.BigDecimal bigDecimal = new java.math.BigDecimal(xNumber.doubleValue());
            if (bigDecimal.compareTo(this.getMaximum()) < 0 || this.isInclusive() && bigDecimal.compareTo(this.getMaximum()) == 0) {
                return stringable;
            }
            String string = "Value not within the range [inf. ,";
            string = String.valueOf(string) + this.getMaximum() + (super.isInclusive() ? "]" : ")");
            throw new FilterException(stringable, string);
        }

        public void setMaximum(java.math.BigDecimal bigDecimal) {
            if (bigDecimal == null) {
                return;
            }
            java.math.BigDecimal bigDecimal2 = this.getMaximum();
            this.maximum = bigDecimal;
            if (!this.getMaximum().equals(bigDecimal2)) {
                this.changeAdapter.firePropertyChange(MaximumBoundFilter.MAXIMUM, bigDecimal2, this.getMaximum());
            }
        }

        public java.math.BigDecimal getMaximum() {
            return this.maximum;
        }
    }
}

