/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs;

import edu.neu.ccs.XObject;
import java.text.ParseException;

public class XChar
extends XObject {
    private char value = '\u0000';

    public XChar() {
    }

    public XChar(char c) {
        this.value = c;
    }

    public XChar(String string) throws ParseException {
        this.fromStringData(string);
    }

    public void fromStringData(String string) throws ParseException {
        char c = this.value;
        if (string == null) {
            throw new ParseException("Input was null.", -1);
        }
        if (string.length() == 0) {
            throw new ParseException("No input provided. ", -1);
        }
        if (string.length() > 1) {
            throw new ParseException("Provide one character only. ", 1);
        }
        this.value = string.charAt(0);
        this.changeAdapter.firePropertyChange("value", new Character(c), string);
    }

    public String toStringData() {
        return String.valueOf(this.value);
    }

    public boolean equals(Object object) {
        if (object instanceof XChar) {
            return this.getValue() == ((XChar)object).getValue();
        }
        return false;
    }

    public int hashCode() {
        return new Character(this.getValue()).hashCode();
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public void setValue(char c) {
        char c2 = this.value;
        this.value = c;
        if (this.getValue() != c2) {
            this.changeAdapter.firePropertyChange("value", new Character(c2), new Character(this.getValue()));
        }
    }

    public char getValue() {
        return this.value;
    }

    public static char parseChar(String string) throws NumberFormatException {
        try {
            return new XChar((String)string).value;
        }
        catch (ParseException parseException) {
            throw new NumberFormatException(XObject.formatErrorMessage(parseException, string));
        }
    }

    public static char[] toPrimitiveArray(XChar[] xCharArray) {
        if (xCharArray == null) {
            return null;
        }
        char[] cArray = new char[xCharArray.length];
        int n = 0;
        while (n < cArray.length) {
            if (xCharArray[n] != null) {
                cArray[n] = xCharArray[n].getValue();
            }
            ++n;
        }
        return cArray;
    }

    public static XChar[] toXArray(char[] cArray) {
        if (cArray == null) {
            return null;
        }
        XChar[] xCharArray = new XChar[cArray.length];
        int n = 0;
        while (n < xCharArray.length) {
            xCharArray[n] = new XChar(cArray[n]);
            ++n;
        }
        return xCharArray;
    }
}

