/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs;

import edu.neu.ccs.XNumber;
import edu.neu.ccs.parser.Parser;
import edu.neu.ccs.parser.ParserUtilities;
import java.math.BigInteger;
import java.text.ParseException;

public class XBigInteger
extends XNumber {
    private BigInteger value = BigInteger.ZERO;

    public XBigInteger() {
    }

    public XBigInteger(BigInteger bigInteger) {
        this.setValue(bigInteger);
    }

    public XBigInteger(String string) throws ParseException {
        this.fromStringData(string);
    }

    public void fromStringData(String string) throws ParseException {
        if (string == null) {
            throw new ParseException("Input was null.", -1);
        }
        BigInteger bigInteger = this.value;
        Parser parser = ParserUtilities.getDefaultParser();
        Object object = parser.parse(string);
        if (!(object instanceof XNumber)) {
            throw new ParseException("Expected numeric value.", string.length());
        }
        XBigInteger xBigInteger = ParserUtilities.toXBigInteger((XNumber)object);
        this.value = xBigInteger.getValue();
        this.changeAdapter.firePropertyChange("value", bigInteger, string);
    }

    public String toStringData() {
        return this.value.toString();
    }

    public byte byteValue() {
        BigInteger bigInteger = new BigInteger("127");
        BigInteger bigInteger2 = new BigInteger("-128");
        if (this.getValue().compareTo(bigInteger) > 0 || this.getValue().compareTo(bigInteger2) < 0) {
            throw new NumberFormatException("Number beyond precision of a byte.");
        }
        return (byte)this.getValue().intValue();
    }

    public short shortValue() {
        BigInteger bigInteger = new BigInteger("32767");
        BigInteger bigInteger2 = new BigInteger("-32768");
        if (this.getValue().compareTo(bigInteger) > 0 || this.getValue().compareTo(bigInteger2) < 0) {
            throw new NumberFormatException("Number beyond precision of a short.");
        }
        return (short)this.getValue().intValue();
    }

    public int intValue() {
        BigInteger bigInteger = new BigInteger("2147483647");
        BigInteger bigInteger2 = new BigInteger("-2147483648");
        if (this.getValue().compareTo(bigInteger) > 0 || this.getValue().compareTo(bigInteger2) < 0) {
            throw new NumberFormatException("Number beyond precision of an int.");
        }
        return this.getValue().intValue();
    }

    public long longValue() {
        BigInteger bigInteger = new BigInteger("9223372036854775807");
        BigInteger bigInteger2 = new BigInteger("-9223372036854775808");
        if (this.getValue().compareTo(bigInteger) > 0 || this.getValue().compareTo(bigInteger2) < 0) {
            throw new NumberFormatException("Number beyond precision of a long.");
        }
        return this.getValue().longValue();
    }

    public float floatValue() {
        return this.getValue().floatValue();
    }

    public double doubleValue() {
        return this.getValue().doubleValue();
    }

    public boolean equals(Object object) {
        if (object instanceof XBigInteger) {
            return this.getValue().equals(((XBigInteger)object).getValue());
        }
        return this.getValue().equals(object);
    }

    public int hashCode() {
        return this.getValue().hashCode();
    }

    public String toString() {
        return this.value.toString();
    }

    public void setValue(BigInteger bigInteger) {
        BigInteger bigInteger2 = this.value;
        if (bigInteger == null) {
            bigInteger = BigInteger.ZERO;
        }
        this.value = bigInteger;
        if (!this.getValue().equals(bigInteger2)) {
            this.changeAdapter.firePropertyChange("value", bigInteger2, this.getValue());
        }
    }

    public BigInteger getValue() {
        return this.value;
    }

    public static BigInteger[] toPrimitiveArray(XBigInteger[] xBigIntegerArray) {
        if (xBigIntegerArray == null) {
            return null;
        }
        BigInteger[] bigIntegerArray = new BigInteger[xBigIntegerArray.length];
        int n = 0;
        while (n < bigIntegerArray.length) {
            if (xBigIntegerArray[n] != null) {
                bigIntegerArray[n] = xBigIntegerArray[n].getValue();
            }
            ++n;
        }
        return bigIntegerArray;
    }

    public static XBigInteger[] toXArray(BigInteger[] bigIntegerArray) {
        if (bigIntegerArray == null) {
            return null;
        }
        XBigInteger[] xBigIntegerArray = new XBigInteger[bigIntegerArray.length];
        int n = 0;
        while (n < xBigIntegerArray.length) {
            if (bigIntegerArray[n] != null) {
                xBigIntegerArray[n] = new XBigInteger(bigIntegerArray[n]);
            }
            ++n;
        }
        return xBigIntegerArray;
    }
}

