import java.awt.*;
import edu.neu.ccs.gui.*;

public class SimpleTests extends JPFalt {
	public static void main(String[] args) { new SimpleTests(); }
	
	Balloon b1 = new Balloon(100, 200, 25, Color.red);
	Balloon b2 = new Balloon(200, 100, 25, Color.blue);
	
	

	public void BalloonTest() {
		
		println("Ballon class tests");
		
		println("\nConstructor test:");
		println("" + b1.toString());	
		println("" + b2);
		
		testHeader("getDiameter");
		expected(50);
		actual(b2.getDiameter());
		
		testHeader("moveBalloon");
		expected(new Balloon(150, 150, 25, Color.red));
		actual(b1.moveBalloon(50, -50));
		
		testHeader("distanceFromTop");
		expected(200 - 25);
		actual(b1.distanceFromTop());
		
		testHeader("isHigherThan");
		expected(false);
		actual(b1.isHigherThan(b2));
		
		testHeader("paintBalloon");
		b1.paintBalloon(window);
		b2.paintBalloon(window);
		
		
	}
	
	public void testGuiInput(){
		BalloonInputView bView = new BalloonInputView();
		println("The first balloon:\n" + bView.demandBalloon());
		
		Balloon b3 = BalloonInputView.demandOneBalloon();
		println("We paint the second balloon \n");
		b3.paintBalloon(window);
		
		try{
			println("We request and paint the third balloon \n");
			Balloon b4 = bView.requestBalloon();
			b4.paintBalloon(window);
		}
		catch(CancelledException e){
			println("No balloon given");
		}
		
		// try to get another balloon
		try{
			println("Request through a static method \n");
			Balloon b5 = BalloonInputView.requestOneBalloon();
			b5.paintBalloon(window);
		}
		catch(CancelledException e){
			println("No balloon given");
		}		
	}
	
	public void testConsoleInput(){
		ConsoleBalloonInput cbi = new ConsoleBalloonInput();
		
		// demand a balloon and paint it
		(cbi.demandBalloon()).paintBalloon(window);
		
		// request a balloon
		try{
			(cbi.requestBalloon()).paintBalloon(window);
		}
		catch(CancelledException e){
			console.out.println("No balloon given");
		}
		
	}
	   
    public void testBalloonControl(){
		BalloonControl bc = new BalloonControl(window);
		GeneralDialog.showOKDialog(bc, "Balloon Control");		
	}
	
}
