/*
 * @(#)JPFalt.java     1.0  1 October 2002, modified 2 March 2004
 *
 * Copyright 2002
 * College of Computer Science
 * Northeastern University
 * Boston, MA  02115
 *
 * This software may be used for educational purposes as long as
 * this copyright notice is retained intact at the top of all files.
 *
 * To discuss commercial use of this software, contact 
 * Prof. Richard Rasala or Prof. Viera K. Proulx at the Northeastern 
 * University College of Computer and Information Science: 617-373-2462.
 *
 * The principal software developer on this project is Jeff Raab.
 *
 * Should this software be modified, the words "Modified from 
 * Original" must be included as a comment below this notice.
 *
 * All publication rights are retained.  This software or its 
 * documentation may not be published in any media either in whole
 * or in part without explicit permission.
 *
 * This software was created with support from Northeastern 
 * University and from NSF grant DUE-9950829.
 */
//package edu.neu.ccs.jpf;

import edu.neu.ccs.console.*;
import edu.neu.ccs.gui.*;
import edu.neu.ccs.util.*;

/**
 * <P>The <I>Java Power Framework</I> class <CODE>JPF</CODE> provides the
 * foundation for creating an automatic Java GUI application with access to:
 *
 * <UL>
 *   <LI> the JPT <CODE>console</CODE> I/O via the interface
 *        {@link edu.neu.ccs.console.ConsoleAware <CODE>ConsoleAware</CODE>}
 *   <LI> a simple graphics window using a
 *        {@link edu.neu.ccs.gui.BufferedPanel <CODE>BufferedPanel</CODE>}.
 * </UL>
 *
 * <P>In this automatic Java GUI application. the action buttons are created
 * automatically from <CODE>public</CODE> methods whose arguments and return
 * type are one of the following types:
 *
 * <UL>
 *   <LI> <CODE>void</CODE>
 *   <LI> <CODE>boolean, char, byte, short, int, long, float, double</CODE>
 *   <LI> <CODE>String, Color, BigInteger, BigDecimal</CODE>
 *   <LI> any type that implements the JPT
 *        {@link edu.neu.ccs.Stringable <CODE>Stringable</CODE>} interface.
 * </UL>
 *
 * <P>The creation of the automatic Java GUI application is accomplished by a
 * combination of Java reflection and the use of the rest of the Java Power
 * Tools.  Since these techniques are encapsulated, the user of the <I>Java
 * Power Framework</I> need not have any knowledge of the JPT.
 *
 * <P>To use the <I>Java Power Framework</I> class <CODE>JPF</CODE>, simply
 * define a class that extends <CODE>JPF</CODE>, directly or indirectly,
 * and execute the default constructor on that new class.
 *
 * <P>For example, if a class named <CODE>Methods</CODE> extends
 * <CODE>JPF</CODE>, directly or indirectly, then all <CODE>public</CODE>
 * methods that satisfy the above constraints and are defined either in the
 * class <CODE>Methods</CODE> itself or in some intermediate class between
 * <CODE>Methods</CODE> and <CODE>JPF</CODE> will give rise to buttons in
 * the automatically generated GUI application.
 *
 * <P>The structure of a typical <CODE>Methods</CODE> class that directly
 * extends <CODE>JPF</CODE> will therefore look as follows:
 *
 * <PRE><CODE>
 *    public class Methods extends JPF {
 *
 *        public static void main(String[] args) { new Methods(); }
 *
 *        // enter here any member or static data declarations as desired
 *
 *        // enter here the public methods to be made into GUI buttons
 *
 *        // enter here any non-public helper methods as desired
 *    }
 * </CODE></PRE>
 * 
 * <P>The <I>Java Power Framework</I> may be used to create GUI buttons in
 * an automatically generated application for any of the following purposes:
 *
 * <UL>
 *   <LI>To write experimental code that will test Java language features.
 *   <LI>To write a systematic suite of tests for one or more separate classes.
 *   <LI>To write small on-the-fly applications using single frames or dialogs. 
 *   <LI>To write methods that will launch one or more separate Java applications
 *       that have been defined in other classes.
 * </UL>
 *
 * <P>To illustrate how to define a method to launch a separate Java application
 * that we will name, for convenience, <CODE>Foo</CODE>, here is the code:
 *
 * <PRE><CODE>
 *        public void LaunchFoo() { Foo.main(null); }
 * </CODE></PRE>
 *
 * Placing this code in the <CODE>Methods</CODE> class will cause a button to be
 * created in the automatic GUI that is labeled "LaunchFoo" and which launches
 * the application <CODE>Foo</CODE> when clicked.
 *
 * <P>The class <CODE>JPF</CODE> itself extends {@link JPFBase <CODE>JPFBase</CODE>}.
 * The class <CODE>JPFBase</CODE> provides a series of methods that may be used to
 * determine if a class possesses a required set of constructors and/or methods.
 * These testing methods are automatically inherited by any class <CODE>Methods</CODE>
 * that extends <CODE>JPF</CODE> and may be used to create unit test suites.
 *
 * @author Viera Proulx
 * @author Jason Jay Rodrigues
 * @author Richard Rasala
 * @author Jeff Raab
 * @version 2.2
 * @since 2.2
 */
public class JPFalt
    extends JPFBaseAlt
    implements JPTConstants, ConsoleAware
{
    /** The graphics buffered panel window. */
    public BufferedPanel window = null;
    
    /** The parent Java application. */
    JPFApplicationAlt application = null;
    
    /** The frame title. */
    String frameTitle = null;
    
    /////////////////
    // Constructor //
    /////////////////
    
    /**
     * Construct the JPF application using as the given initializer the
     * derived class that uses this constructor.
     */
    public JPFalt() {
        // create an application object that references this initializer
        application = new JPFApplicationAlt(this, frameTitle);
            
        // obtain the graphics window
        window = application.getGraphicsWindow();
    }
    
    ////////////////
    // Public API //
    ////////////////
    
    /**
     * Sets the title of the application frame
     * to the given title.
     *
     * @param title title text for the frame
     */
    public void setFrameTitle(String title) {
        frameTitle = title;
        
        if (application != null)
            application.setFrameTitle(title);
    }

    ///////////////////////////////////////
    // Helper Methods for Console Output //
    ///////////////////////////////////////

    ///////////////////////////////////////////////////////
	// Shortcut methods for accessing the console output //
	// and printing the method actual header               //
    ///////////////////////////////////////////////////////
    
    protected void println(Object s){
    	console.out.println(s.toString());
    }
    
    protected void println(byte s){
    	console.out.println("" + s);
    }
    
    protected void println(short s){
    	console.out.println("" + s);
    }
    
    protected void println(int s){
    	console.out.println("" + s);
    }
    
    protected void println(long s){
    	console.out.println("" + s);
    }
    
    protected void println(float s){
    	console.out.println("" + s);
    }
    
    protected void println(double s){
    	console.out.println("" + s);
    }
    
    protected void println(boolean s){
    	console.out.println("" + s);
    }
    
    protected void println(char s){
    	console.out.println("" + s);
    }
    
    protected void println(){
    	console.out.println();
    }
    
    /** The header for a method test. */
    protected void testHeader(String methodName){
    	console.out.println("\nTesting the method " + methodName);
    }

	/** printing the expected results for actuals */
    protected void expected(Object s){
    	console.out.println("Expected result: " + s.toString());
    }
    
    protected void expected(byte s){
    	console.out.println("Expected result: " + s);
    }
    
    protected void expected(short s){
    	console.out.println("Expected result: " + s);
    }
    
    protected void expected(int s){
    	console.out.println("Expected result: " + s);
    }
    
    protected void expected(long s){
    	console.out.println("Expected result: " + s);
    }
    
    protected void expected(float s){
    	console.out.println("Expected result: " + s);
    }
    
    protected void expected(double s){
    	console.out.println("Expected result: " + s);
    }
    
    protected void expected(boolean s){
    	console.out.println("Expected result: " + s);
    }
    
    protected void expected(char s){
    	console.out.println("Expected result: " + s);
    }
    
    protected void expected(){
    	console.out.println("Expected result: ");
    }
    



	/** test results */
    protected boolean test(Object s1, Object s2){
    	return s1.equals(s2);
    }
    
    protected boolean test(byte s1, byte s2){
    	return s1 == s2;
    }
    
	// assumes that tollerance is positive
    protected boolean test(float s1, float s2, float tollerance){
    	return Math.abs(s1 - s2) < tollerance;
    }
    
	// assumes that tollerance is positive
    protected boolean test(double s1, double s2, double tollerance){
    	return Math.abs(s1 - s2) < tollerance;
    }
    

    protected boolean test(short s1, short s2){
    	return s1 == s2;
    }
    
    protected boolean test(int s1, int s2){
    	return s1 == s2;
    }
    
    protected boolean test(long s1, long s2){
    	return s1 == s2;
    }
    
    protected boolean test(boolean s1, boolean s2){
    	return s1 == s2;
    }

    protected boolean test(char s1, char s2){
    	return s1 == s2;
    }
    
    
	/////////////// END OF TESTS /////////////////




	/** printing the test results for Tests */
    protected void actual(Object s){
    	console.out.println("Actual result:   " + s.toString());
    }
    
    protected void actual(byte s){
    	console.out.println("Actual result:   " + s);
    }
    
    protected void actual(short s){
    	console.out.println("Actual result:   " + s);
    }
    
    protected void actual(int s){
    	console.out.println("Actual result:   " + s);
    }
    
    protected void actual(long s){
    	console.out.println("Actual result:   " + s);
    }
    
    protected void actual(float s){
    	console.out.println("Actual result:   " + s);
    }
    
    protected void actual(double s){
    	console.out.println("Actual result:   " + s);
    }
    
    protected void actual(boolean s){
    	console.out.println("Actual result:   " + s);
    }
    
    protected void actual(char s){
    	console.out.println("Actual result:    " + s);
    }
    
    protected void actual(){
    	console.out.println("Expected result: ");
    }
    
    protected void pressReturn(String s){
        console.pressReturn(s);
    }

    protected void pressReturn(){
        console.pressReturn();
    }
    
    protected void clearWindow(BufferedPanel window){
        window.clearPanel();
        window.repaint();
    }

}

