/*
 * @(#)BalloonInputView.java  17 March 2004
 *
 *   Viera Proulx      vkp@ccs.neu.edu
 */

import edu.neu.ccs.*;
import edu.neu.ccs.gui.*;
import edu.neu.ccs.util.*;

import java.awt.*;
import java.awt.geom.*;
import java.text.NumberFormat;
import java.text.DecimalFormat;
import javax.swing.*;

/**
 * View for input and manipulation of a Balloon object.
 */
public class BalloonInputView extends Display
    implements JPTConstants, BalloonInput {
    
    /////////////////
    // Member Data //
    /////////////////
    
    /** Display field for the x coordinate of the center. */
    protected TextFieldView xTFV;

    /** Display field for the y coordinate of the center. */
    protected TextFieldView yTFV;

   /** The slider in the GUI that controls radius. */
    protected SliderView rSlider;

    /** The view in the GUI that displays the color. */
    protected ColorView cView;
   	    
   	    
    
    public BalloonInputView() {
		super();
		
 		// add the internal panel to the Display
		add(createDisplay());
		
		// set the title and annotation for the Display
		setTitleText("Balloon");
		
    }
    
    //////////////////////////////////
    // Helpers for the Constructors //
    //////////////////////////////////
    
    /**
     * Construct a table panel display for one balloon, containing
     * three text field views, sliders, and color view
     */
    protected TablePanel createDisplay() {
    	
        createViews();
        
        TablePanel balloonDisplay = new TablePanel(new Object[][]{
            {"X:", xTFV},
            {"Y:", yTFV},
            {"R:", rSlider},
            {"Color:", cView}},
            VERTICAL, 5, 5);
        
        return balloonDisplay;        	
                	        
    }
    
	/**
	 * Creates three text field views with the desired default values
	 * a ColorView, and three Sliders
	 */
    protected void createViews() {
    
    	xTFV = new TextFieldView(
	        "" + 100,						 // default value
	        "Please enter a real number:",   // error prompt
	        "x coordinate error",			 // error message
	        80);							 // field width
	             
    	yTFV = new TextFieldView(
	        "" + 200,
	        "Please enter a real number:",
	        "y coordinate error",
	        80);
	        
	    rSlider = new SliderView(HORIZONTAL, 0, 400, 25);
	        
	    cView = new ColorView(Color.red, true);
	        
	    xTFV.setDefaultViewState("" + 100);
	    yTFV.setDefaultViewState("" + 200);	    
    }

    
    public Balloon demandBalloon(){
        return new Balloon( xTFV.demandInt(),
							yTFV.demandInt(),
							rSlider.getValue(),
							cView.getColor());
    }

    public Balloon requestBalloon() throws CancelledException{
        return new Balloon( xTFV.requestInt(),
							yTFV.requestInt(),
							rSlider.getValue(),
							cView.getColor());
    }

	public static Balloon requestOneBalloon() throws CancelledException{
		BalloonInputView bGUI = new BalloonInputView();
		GeneralDialog.showOKDialog(bGUI, "Balloon Input");
		return bGUI.requestBalloon();
	}
	
	public static Balloon demandOneBalloon(){
		BalloonInputView bGUI = new BalloonInputView();
		GeneralDialog.showOKDialog(bGUI, "Balloon Input");
		return bGUI.demandBalloon();
	}
	
}