package student;

import java.util.*;
import sorting.SortAlgorithm;

/** A wrapper for the HeapSort algorithm */
public abstract class SortingHeapSort<T> implements SortAlgorithm<T>{

    /** The <code>ArrayList</code> to sort */
    public ArrayList<T> alist;
  
    /** Initialize the list (to be sorted) from the given List.  The
     *    list is copied to avoid mutating other references.
     * @param alist the <code>ArrayList</code> to sort
     */
    public void init(ArrayList<T> alistin){
        this.alist = new ArrayList<T>();
        for (T t: alistin){
            this.alist.add(t);
        }
    }
  
  
    /** Sort the given <code>ArrayList</code> using the given
     * <code>Comparator</code> and return the sorted result.  For
     * <em>in-place</em> algorithms <code>alist</code> should be the
     * result.
     * @param alist the <code>ArrayList</code> to sort
     * @param comp the <code>Comparator</code> that determines the ordering
     * @return the sorted <code>ArrayList</code>
     */
    public ArrayList<T> sort(Comparator<T> comp){
        return heapsort(this.alist, comp);
    }
  
    /** Sort the given ArrayList with the given Comparator using the
     *    HeapSort algorithm */
    public abstract ArrayList<T> heapsort(ArrayList<T> alist, Comparator<T> comp);
}
