/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.util;

import edu.neu.ccs.util.TextTools;
import java.io.InputStream;
import java.net.URL;

public class WebTools {
    private WebTools() {
    }

    public static byte[] readDataFromWeb(String urlString) {
        try {
            URL url = new URL(urlString);
            InputStream stream = url.openStream();
            byte[] data = new byte[stream.available()];
            stream.read(data);
            stream.close();
            return data;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage());
        }
    }

    public static String readTextFileFromWeb(String urlString) {
        byte[] data = WebTools.readDataFromWeb(urlString);
        return new String(data);
    }

    public static String[] readNonEmptyLinesFromWeb(String urlString) {
        String contents = WebTools.readTextFileFromWeb(urlString);
        return TextTools.extractNonEmptyLines(contents);
    }

    public static String[] readFileNamesFromWeb(String filelistURL, String filelist) {
        try {
            String fullURL = String.valueOf(WebTools.appendSlashIfNeeded(filelistURL)) + filelist;
            return WebTools.readNonEmptyLinesFromWeb(fullURL);
        }
        catch (Exception ex) {
            return new String[0];
        }
    }

    public static String appendSlashIfNeeded(String baseURL) {
        if (baseURL == null) {
            return baseURL;
        }
        int length = baseURL.length();
        if (length == 0) {
            return baseURL;
        }
        if (baseURL.charAt(length - 1) != '/') {
            baseURL = String.valueOf(baseURL) + "/";
        }
        return baseURL;
    }
}

