/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.util;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.Vector;

public class TextTools {
    private TextTools() {
    }

    public static String readTextFile(String path) {
        if (path == null) {
            throw new RuntimeException("Null path in readTextFile");
        }
        int bufferSize = 8092;
        StringBuffer buffer = new StringBuffer(bufferSize);
        char[] data = new char[bufferSize];
        try {
            int count;
            FileReader reader = new FileReader(path);
            while ((count = reader.read(data)) > 0) {
                buffer.append(data, 0, count);
            }
            reader.close();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex.getMessage());
        }
        return buffer.toString();
    }

    public static void writeTextFile(String path, String data) {
        if (path == null) {
            throw new RuntimeException("Null path in writeTextFile");
        }
        if (data == null) {
            throw new RuntimeException("Null data in writeTextFile");
        }
        try {
            FileWriter writer = new FileWriter(path);
            writer.write(data);
            writer.close();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex.getMessage());
        }
    }

    public static void copyTextFile(String oldPath, String newPath) {
        TextTools.writeTextFile(newPath, TextTools.readTextFile(oldPath));
    }

    public static String[] readNonEmptyLines(String path) {
        return TextTools.extractNonEmptyLines(TextTools.readTextFile(path));
    }

    public static String[] extractNonEmptyLines(String data) {
        if (data == null || data.length() == 0) {
            return new String[0];
        }
        StringTokenizer tokenizer = new StringTokenizer(data, "\n");
        Vector<String> list = new Vector<String>();
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken().trim();
            if (token.length() <= 0) continue;
            list.add(token);
        }
        return list.toArray(new String[0]);
    }

    public static String[] readFileNames(String directory, String filelist) {
        try {
            return TextTools.readNonEmptyLines(TextTools.makePath(directory, filelist));
        }
        catch (Exception ex) {
            return new String[0];
        }
    }

    public static String makePath(String directory, String filename) {
        if (directory == null) {
            throw new RuntimeException("Null directory in makePath");
        }
        if (filename == null) {
            throw new RuntimeException("Null filename in makePath");
        }
        String insert = "";
        int length = directory.length();
        if (length > 0 && directory.charAt(length - 1) != File.separatorChar) {
            insert = File.separator;
        }
        return String.valueOf(directory) + insert + filename;
    }
}

