/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.util;

import edu.neu.ccs.util.JPTUtilities;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Vector;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Sequence;
import javax.sound.midi.Sequencer;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.UnsupportedAudioFileException;

public class SoundUtilities {
    private static Vector currentLines = new Vector();
    private static float gain = 1.0f;
    private static boolean muted = false;
    private static float pan = 0.0f;
    static /* synthetic */ Class class$0;

    public static void setGain(float dB) {
        gain = dB;
        Line[] lines = currentLines.toArray(new Line[0]);
        int i = 0;
        while (i < lines.length) {
            SoundUtilities.applyGain(gain, lines[i]);
            ++i;
        }
    }

    public static float getGain() {
        return gain;
    }

    public static void setMuted(boolean isMuted) {
        if (isMuted == muted) {
            return;
        }
        muted = isMuted;
        SoundUtilities.setGain(gain);
    }

    public static boolean isMuted() {
        return muted;
    }

    public static void setPan(float p) {
        pan = p;
        Line[] lines = currentLines.toArray(new Line[0]);
        int i = 0;
        while (i < lines.length) {
            SoundUtilities.applyPan(pan, lines[i]);
            ++i;
        }
    }

    public static float getPan() {
        return pan;
    }

    public static SourceDataLine playSound(String soundFileName) {
        return SoundUtilities.playSound(new File(soundFileName));
    }

    public static SourceDataLine playSound(File soundFile) {
        try {
            return SoundUtilities.playImpl(AudioSystem.getAudioInputStream(soundFile));
        }
        catch (IOException iOException) {
        }
        catch (UnsupportedAudioFileException unsupportedAudioFileException) {
            // empty catch block
        }
        return null;
    }

    public static SourceDataLine playSound(URL soundURL) {
        try {
            return SoundUtilities.playImpl(AudioSystem.getAudioInputStream(soundURL));
        }
        catch (IOException iOException) {
        }
        catch (UnsupportedAudioFileException unsupportedAudioFileException) {
            // empty catch block
        }
        return null;
    }

    public static Thread playMidi(String midiFileName) {
        try {
            return SoundUtilities.playImpl(MidiSystem.getSequence(new File(midiFileName)));
        }
        catch (IOException iOException) {
        }
        catch (InvalidMidiDataException invalidMidiDataException) {
            // empty catch block
        }
        return null;
    }

    public static Thread playMidi(File midiFile) {
        try {
            return SoundUtilities.playImpl(MidiSystem.getSequence(midiFile));
        }
        catch (IOException iOException) {
        }
        catch (InvalidMidiDataException invalidMidiDataException) {
            // empty catch block
        }
        return null;
    }

    public static Thread playMidi(URL midiURL) {
        try {
            SoundUtilities.playImpl(MidiSystem.getSequence(midiURL));
        }
        catch (IOException iOException) {
        }
        catch (InvalidMidiDataException invalidMidiDataException) {
            // empty catch block
        }
        return null;
    }

    private static SourceDataLine playImpl(final AudioInputStream stream) {
        SourceDataLine line;
        DataLine.Info info;
        final AudioFormat soundFormat = stream.getFormat();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("javax.sound.sampled.SourceDataLine");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (!AudioSystem.isLineSupported(info = new DataLine.Info(clazz, soundFormat))) {
            return null;
        }
        try {
            line = (SourceDataLine)AudioSystem.getLine(info);
            line.open(soundFormat, 16384);
        }
        catch (LineUnavailableException ex) {
            return null;
        }
        SoundUtilities.applyGain(gain, line);
        SoundUtilities.applyPan(pan, line);
        currentLines.add(line);
        Thread playThread = new Thread(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                try {
                    int size = line.getBufferSize() / 8 * soundFormat.getFrameSize();
                    byte[] buffer = new byte[size];
                    block2: while (true) {
                        int count;
                        if ((count = stream.read(buffer)) == -1) {
                            line.stop();
                            line.close();
                            break;
                        }
                        while (true) {
                            if (count <= 0) continue block2;
                            count -= line.write(buffer, 0, count);
                        }
                        break;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                SoundUtilities.removeLine(line);
            }
        };
        line.start();
        playThread.start();
        return line;
    }

    private static Thread playImpl(Sequence midiSong) {
        Sequencer midiSequencer;
        try {
            midiSequencer = MidiSystem.getSequencer();
            if (!midiSequencer.isOpen()) {
                midiSequencer.open();
            }
        }
        catch (MidiUnavailableException ex) {
            return null;
        }
        try {
            midiSequencer.setSequence(midiSong);
        }
        catch (InvalidMidiDataException ex) {
            return null;
        }
        Thread playThread = new Thread(){

            public void run() {
                midiSequencer.start();
                while (midiSequencer.isRunning()) {
                    JPTUtilities.pauseThread(50L);
                }
                midiSequencer.stop();
            }
        };
        playThread.start();
        return playThread;
    }

    private static void removeLine(Line l) {
        currentLines.remove(l);
    }

    private static void applyGain(float gain, Line l) {
        try {
            if (muted) {
                gain = -3.4028235E38f;
            }
            FloatControl gainControl = (FloatControl)l.getControl(FloatControl.Type.MASTER_GAIN);
            gain = Math.max(gain, gainControl.getMinimum());
            gain = Math.min(gain, gainControl.getMaximum());
            gainControl.setValue(gain);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private static void applyPan(float pan, Line l) {
        try {
            FloatControl panControl = (FloatControl)l.getControl(FloatControl.Type.PAN);
            pan = Math.max(pan, panControl.getMinimum());
            pan = Math.min(pan, panControl.getMaximum());
            panControl.setValue(pan);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

