/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.util;

import edu.neu.ccs.util.MathUtilities;

public class ProbStatTools {
    private ProbStatTools() {
    }

    public static int[] integerSequence(int n) {
        return ProbStatTools.integerSequence(n, 0);
    }

    public static int[] integerSequence(int n, int start) {
        if (n <= 0) {
            return new int[0];
        }
        int[] result = new int[n];
        int i = 0;
        while (i < n) {
            result[i] = start + i;
            ++i;
        }
        return result;
    }

    public static int[] randomPermutation(int n) {
        return ProbStatTools.randomPermutation(n, 0);
    }

    public static int[] randomPermutation(int n, int start) {
        int[] data = ProbStatTools.integerSequence(n, start);
        ProbStatTools.randomPermutationInSitu(data);
        return data;
    }

    public static int[] randomPermutation(int[] data) {
        data = ProbStatTools.repeatData(data, 1);
        ProbStatTools.randomPermutationInSitu(data);
        return data;
    }

    public static void randomPermutationInSitu(int[] data) {
        if (data == null) {
            return;
        }
        int n = data.length;
        if (n < 2) {
            return;
        }
        int m = n - 1;
        int i = 0;
        while (i < m) {
            int j = MathUtilities.randomInt(i, m);
            if (j != i) {
                int copy = data[j];
                data[j] = data[i];
                data[i] = copy;
            }
            ++i;
        }
    }

    public static int[] randomEvenPermutation(int n) {
        return ProbStatTools.randomEvenPermutation(n, 0);
    }

    public static int[] randomEvenPermutation(int n, int start) {
        int[] data = ProbStatTools.integerSequence(n, start);
        ProbStatTools.randomEvenPermutationInSitu(data);
        return data;
    }

    public static int[] randomEvenPermutation(int[] data) {
        data = ProbStatTools.repeatData(data, 1);
        ProbStatTools.randomEvenPermutationInSitu(data);
        return data;
    }

    public static void randomEvenPermutationInSitu(int[] data) {
        if (data == null) {
            return;
        }
        int n = data.length;
        if (n < 3) {
            return;
        }
        int m = n - 1;
        int k = n - 2;
        int swaps = 0;
        int i = 0;
        while (i < k) {
            int j = MathUtilities.randomInt(i, m);
            if (j != i) {
                int copy = data[j];
                data[j] = data[i];
                data[i] = copy;
                ++swaps;
            }
            ++i;
        }
        if (swaps % 2 != 0) {
            int copy = data[m];
            data[m] = data[k];
            data[k] = copy;
        }
    }

    public static int reversals(int[] data) {
        if (data == null) {
            return -1;
        }
        int n = data.length;
        if (n <= 1) {
            return 0;
        }
        int m = n - 1;
        int k = 0;
        int i = 0;
        while (i < m) {
            int j = i + 1;
            while (j < n) {
                if (data[i] == data[j]) {
                    return -1;
                }
                if (data[i] > data[j]) {
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return k;
    }

    public static int sign(int[] data) {
        int k = ProbStatTools.reversals(data);
        if (k == -1) {
            return 0;
        }
        if (k % 2 == 0) {
            return 1;
        }
        return -1;
    }

    public static int[] nextList(int[] data) {
        int m;
        if (data == null) {
            return null;
        }
        int n = data.length;
        if (n <= 1) {
            return null;
        }
        int i = m = n - 1;
        while (i > 0) {
            if (data[i - 1] < data[i]) break;
            --i;
        }
        if (i == 0) {
            return null;
        }
        int j = i - 1;
        int[] result = new int[n];
        int k = 0;
        while (k < j) {
            result[k] = data[k];
            ++k;
        }
        k = i;
        while (k <= m) {
            result[k] = data[m + i - k];
            ++k;
        }
        int p = i;
        while (result[p] <= data[j]) {
            ++p;
        }
        result[j] = result[p];
        result[p] = data[j];
        return result;
    }

    public static int[] previousList(int[] data) {
        int m;
        if (data == null) {
            return null;
        }
        int n = data.length;
        if (n <= 1) {
            return null;
        }
        int i = m = n - 1;
        while (i > 0) {
            if (data[i - 1] > data[i]) break;
            --i;
        }
        if (i == 0) {
            return null;
        }
        int j = i - 1;
        int[] result = new int[n];
        int k = 0;
        while (k < j) {
            result[k] = data[k];
            ++k;
        }
        k = i;
        while (k <= m) {
            result[k] = data[m + i - k];
            ++k;
        }
        int p = i;
        while (result[p] >= data[j]) {
            ++p;
        }
        result[j] = result[p];
        result[p] = data[j];
        return result;
    }

    public static int[] selectWithRepetition(int n, int k) {
        if (n <= 0 || k <= 0) {
            return new int[0];
        }
        return ProbStatTools.selectWithRepetition(ProbStatTools.integerSequence(n), k);
    }

    public static int[] selectWithNoRepetition(int n, int k) {
        if (k <= 0 || k > n) {
            return new int[0];
        }
        return ProbStatTools.selectWithNoRepetition(ProbStatTools.integerSequence(n), k);
    }

    public static int[] selectWithRepetition(int[] data, int k) {
        if (data == null || k <= 0) {
            return new int[0];
        }
        int size = data.length;
        int[] result = new int[k];
        int i = 0;
        while (i < k) {
            int j = MathUtilities.randomInt(0, size - 1);
            result[i] = data[j];
            ++i;
        }
        return result;
    }

    public static int[] selectWithNoRepetition(int[] data, int k) {
        if (data == null) {
            return new int[0];
        }
        int size = data.length;
        if (k <= 0 || k > size) {
            return new int[0];
        }
        int[] temp = ProbStatTools.repeatData(data, 1);
        int[] result = new int[k];
        int i = 0;
        while (i < k) {
            int j = MathUtilities.randomInt(i, size - 1);
            int copy = temp[i];
            temp[i] = temp[j];
            temp[j] = copy;
            result[i] = temp[i];
            ++i;
        }
        return result;
    }

    public static int[] repeatData(int[] data, int k) {
        if (data == null || k <= 0) {
            return new int[0];
        }
        int size1 = data.length;
        int sizek = k * size1;
        int[] result = new int[sizek];
        int i = 0;
        while (i < size1) {
            int j = 0;
            while (j < k) {
                result[i + j * size1] = data[i];
                ++j;
            }
            ++i;
        }
        return result;
    }
}

