/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.util;

import java.awt.geom.Point2D;

public abstract class Metric {
    public static final Metric EUCLID = new Metric(){

        public double distance(double x1, double y1, double x2, double y2) {
            double x = Math.abs(x2 - x1);
            double y = Math.abs(y2 - y1);
            if (x == 0.0 && y == 0.0) {
                return 0.0;
            }
            if (x <= y) {
                double z = x / y;
                return y * Math.sqrt(1.0 + z * z);
            }
            double z = y / x;
            return x * Math.sqrt(1.0 + z * z);
        }
    };
    public static final Metric MAX = new Metric(){

        public double distance(double x1, double y1, double x2, double y2) {
            double x = Math.abs(x2 - x1);
            double y = Math.abs(y2 - y1);
            return Math.max(x, y);
        }
    };
    public static final Metric SUM = new Metric(){

        public double distance(double x1, double y1, double x2, double y2) {
            double x = Math.abs(x2 - x1);
            double y = Math.abs(y2 - y1);
            return x + y;
        }
    };

    public abstract double distance(double var1, double var3, double var5, double var7);

    public final double distance(Point2D p1, Point2D p2) {
        if (p1 == null || p2 == null) {
            return Double.MAX_VALUE;
        }
        return this.distance(p1.getX(), p1.getY(), p2.getX(), p2.getY());
    }

    public final double distance(double[] p1, double[] p2) {
        if (p1 == null || p2 == null) {
            return Double.MAX_VALUE;
        }
        if (p1.length != 2 || p2.length != 2) {
            return Double.MAX_VALUE;
        }
        return this.distance(p1[0], p1[1], p2[0], p2[1]);
    }

    public final double distance(float[] p1, float[] p2) {
        if (p1 == null || p2 == null) {
            return Double.MAX_VALUE;
        }
        if (p1.length != 2 || p2.length != 2) {
            return Double.MAX_VALUE;
        }
        return this.distance(p1[0], p1[1], p2[0], p2[1]);
    }

    public final boolean isNear(double x1, double y1, double x2, double y2, double epsilon) {
        return this.distance(x1, y1, x2, y2) <= epsilon;
    }

    public final boolean isNear(Point2D p1, Point2D p2, double epsilon) {
        return this.distance(p1, p2) <= epsilon;
    }

    public final boolean isNear(double[] p1, double[] p2, double epsilon) {
        return this.distance(p1, p2) <= epsilon;
    }

    public final boolean isNear(float[] p1, float[] p2, double epsilon) {
        return this.distance(p1, p2) <= epsilon;
    }
}

