/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.util;

public class MathUtilities {
    public static int randomInt(int a) {
        return MathUtilities.randomInt(0, a);
    }

    public static int randomInt(int a, int b) {
        long v;
        long u;
        if (a <= b) {
            u = a;
            v = b;
        } else {
            u = b;
            v = a;
        }
        long r = u + (long)((double)(v - u + 1L) * Math.random());
        if (r > v) {
            r = v;
        }
        return (int)r;
    }

    public static double randomDouble(double x) {
        return Math.random() * x;
    }

    public static double randomDouble(double x, double y) {
        double b;
        double a;
        if (x <= y) {
            a = x;
            b = y;
        } else {
            a = y;
            b = x;
        }
        double t = Math.random();
        double r = a + t * (b - a);
        if (r < a) {
            r = a;
        } else if (r > b) {
            r = b;
        }
        return r;
    }

    public static double sindeg(double degrees) {
        return Math.sin(Math.toRadians(degrees));
    }

    public static double cosdeg(double degrees) {
        return Math.cos(Math.toRadians(degrees));
    }

    public static double tandeg(double degrees) {
        return Math.tan(Math.toRadians(degrees));
    }

    public static double asindeg(double value) {
        return Math.toDegrees(Math.asin(value));
    }

    public static double acosdeg(double value) {
        return Math.toDegrees(Math.acos(value));
    }

    public static double atandeg(double value) {
        return Math.toDegrees(Math.atan(value));
    }

    public static double atan2deg(double y, double x) {
        return Math.toDegrees(Math.atan2(y, x));
    }

    public static double sinh(double x) {
        boolean positive;
        boolean bl = positive = x >= 0.0;
        if (positive) {
            double z = Math.exp(x);
            double w = 1.0 / z;
            return (z - w) / 2.0;
        }
        double z = Math.exp(-x);
        double w = 1.0 / z;
        return (w - z) / 2.0;
    }

    public static double cosh(double x) {
        double z = x >= 0.0 ? Math.exp(x) : Math.exp(-x);
        return (z + 1.0 / z) / 2.0;
    }

    public static double tanh(double x) {
        boolean positive;
        boolean bl = positive = x >= 0.0;
        if (positive) {
            double z = Math.exp(x);
            double w = 1.0 / z;
            return (z - w) / (z + w);
        }
        double z = Math.exp(-x);
        double w = 1.0 / z;
        return (w - z) / (z + w);
    }

    public static double asinh(double s) {
        return Math.log(s + Math.sqrt(s * s + 1.0));
    }

    public static double acosh(double c) {
        if (c < 1.0) {
            return Double.NaN;
        }
        return Math.log(c + Math.sqrt(c * c - 1.0));
    }

    public static double atanh(double t) {
        if (Math.abs(t) >= 1.0) {
            return Double.NaN;
        }
        return Math.log(Math.sqrt((1.0 + t) / (1.0 - t)));
    }

    public static int GCD(int a, int b) {
        if (b == 0) {
            return Math.abs(a);
        }
        return MathUtilities.GCD(b, a % b);
    }

    public static long GCD(long a, long b) {
        if (b == 0L) {
            return Math.abs(a);
        }
        return MathUtilities.GCD(b, a % b);
    }

    public static int LCM(int a, int b) {
        if (a == 0 && b == 0) {
            return 0;
        }
        a = Math.abs(a);
        b = Math.abs(b);
        return a * (b / MathUtilities.GCD(a, b));
    }

    public static long LCM(long a, long b) {
        if (a == 0L && b == 0L) {
            return 0L;
        }
        a = Math.abs(a);
        b = Math.abs(b);
        return a * (b / MathUtilities.GCD(a, b));
    }

    public static int modulus(int number, int base) {
        if (base == 0) {
            throw new ArithmeticException("Error in modulus: base is zero");
        }
        if ((number %= (base = Math.abs(base))) < 0) {
            number += base;
        }
        return number;
    }

    public static long modulus(long number, long base) {
        if (base == 0L) {
            throw new ArithmeticException("Error in modulus: base is zero");
        }
        if ((number %= (base = Math.abs(base))) < 0L) {
            number += base;
        }
        return number;
    }

    public static double power(double x, int n) {
        if (n == 0) {
            return 1.0;
        }
        if (n < 0 && x == 0.0) {
            return Double.NaN;
        }
        if (n < 0) {
            n = -n;
            x = 1.0 / x;
        }
        double result = 1.0;
        while (n > 0) {
            if (n % 2 != 0) {
                result *= x;
                --n;
                continue;
            }
            x *= x;
            n /= 2;
        }
        return result;
    }

    public static double root(double x, double n) {
        double NaN = Double.NaN;
        if (n == 0.0) {
            return NaN;
        }
        if (x == 0.0) {
            if (n > 0.0) {
                return 0.0;
            }
            return NaN;
        }
        double y = 1.0 / n;
        if (x > 0.0) {
            return Math.pow(x, y);
        }
        int nn = (int)n;
        if (n == (double)nn && nn % 2 != 0) {
            return -Math.pow(-x, y);
        }
        return NaN;
    }

    public static int[] getTileIndexLimits(double x, double w, double x0, double w0) {
        if (w <= 0.0 || w0 <= 0.0) {
            return null;
        }
        double dx = x - x0;
        double a = Math.floor(dx / w0);
        int i = (int)a;
        if ((double)i != a) {
            return null;
        }
        double b = Math.ceil((dx + w) / w0);
        int j = (int)b;
        if ((double)j != b) {
            return null;
        }
        return new int[]{i, j};
    }
}

