/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.util;

import edu.neu.ccs.console.ConsoleAware;
import edu.neu.ccs.gui.ActionsPanel;
import edu.neu.ccs.gui.SimpleAction;
import edu.neu.ccs.util.JPTUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public class JPTError
extends Error
implements ConsoleAware {
    public JPTError() {
        this("(details not provided)");
    }

    public JPTError(String errorMessage) {
        super(errorMessage);
        if (JPTUtilities.isDebugModeSet()) {
            final JDialog dialog = new JDialog(null, "Error!", true);
            dialog.setDefaultCloseOperation(2);
            JPanel pane = new JPanel(new BorderLayout());
            pane.setBorder(new EmptyBorder(25, 25, 25, 25));
            JLabel prompt = new JLabel("The following error was reported:");
            JLabel message = new JLabel(errorMessage);
            message.setBorder(new EmptyBorder(10, 0, 10, 0));
            ActionsPanel actions = new ActionsPanel();
            actions.addAction(new SimpleAction("Exit Program"){

                public void perform() {
                    System.exit(0);
                }
            });
            actions.addAction(new SimpleAction("Print stack trace"){

                public void perform() {
                    JPTError.this.printStackTrace(JPTError.console.out);
                }
            });
            actions.addAction(new SimpleAction("Ignore"){

                public void perform() {
                    dialog.setVisible(false);
                    dialog.dispose();
                }
            });
            pane.add((Component)prompt, "North");
            pane.add((Component)message, "Center");
            pane.add((Component)actions, "South");
            dialog.setContentPane(pane);
            dialog.pack();
            Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
            dialog.setLocation((screen.width - dialog.getWidth()) / 2, (screen.height - dialog.getHeight()) / 2);
            dialog.setVisible(true);
        }
    }
}

