/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.util;

import edu.neu.ccs.Stringable;
import edu.neu.ccs.XByte;
import edu.neu.ccs.XDouble;
import edu.neu.ccs.XFloat;
import edu.neu.ccs.XInt;
import edu.neu.ccs.XNumber;
import edu.neu.ccs.XShort;
import edu.neu.ccs.filter.FilterException;
import edu.neu.ccs.filter.StringableFilter;
import java.text.ParseException;

public class Hex {
    private static final long low8bits = 255L;
    private static final long low16bits = 65535L;
    private static final long low32bits = 0xFFFFFFFFL;

    private Hex() {
    }

    public static String byteToHex(byte b) {
        return Hex.longToHex(b, 2);
    }

    public static String shortToHex(short s) {
        return Hex.longToHex(s, 4);
    }

    public static String intToHex(int i) {
        return Hex.longToHex(i, 8);
    }

    public static String longToHex(long a) {
        return Hex.longToHex(a, 16);
    }

    public static String floatToHex(float f) {
        return Hex.intToHex(Float.floatToRawIntBits(f));
    }

    public static String doubleToHex(double d) {
        return Hex.longToHex(Double.doubleToRawLongBits(d));
    }

    public static String longToHex(long a, int maxdigits) {
        if (maxdigits < 1) {
            return "";
        }
        String hex = "0123456789ABCDEF";
        char[] digits = new char[maxdigits];
        int k = maxdigits - 1;
        while (k >= 0) {
            digits[k] = hex.charAt((int)(a & 0xFL));
            a >>>= 4;
            --k;
        }
        return new String(digits);
    }

    public static byte hexToByte(String s) throws ParseException {
        return (byte)Hex.hexToLong(s, 2);
    }

    public static short hexToShort(String s) throws ParseException {
        return (short)Hex.hexToLong(s, 4);
    }

    public static int hexToInt(String s) throws ParseException {
        return (int)Hex.hexToLong(s, 8);
    }

    public static long hexToLong(String s) throws ParseException {
        return Hex.hexToLong(s, 16);
    }

    public static float hexToFloat(String s) throws ParseException {
        if (s != null && s.length() != 8) {
            throw new ParseException("Float hex string must have length 8", Math.min(s.length(), 8));
        }
        return Float.intBitsToFloat(Hex.hexToInt(s));
    }

    public static double hexToDouble(String s) throws ParseException {
        if (s != null && s.length() != 16) {
            throw new ParseException("Double hex string must have length 16", Math.min(s.length(), 16));
        }
        return Double.longBitsToDouble(Hex.hexToLong(s));
    }

    public static long hexToLong(String s, int maxdigits) throws ParseException {
        if (s == null) {
            throw new ParseException("String is null", 0);
        }
        int length = s.length();
        int index = 0;
        if (!Hex.isHexString(s)) {
            index = 0;
            while (index < length) {
                if (!Hex.isHexDigit(s.charAt(index))) {
                    throw new ParseException("String is not a hex string", index);
                }
                ++index;
            }
        }
        if (length > maxdigits) {
            throw new ParseException("String is longer than " + maxdigits + "digits", maxdigits);
        }
        if (maxdigits > 16) {
            throw new ParseException("Max digits is larger than 16", 0);
        }
        long x = 0L;
        index = 0;
        while (index < length) {
            x <<= 4;
            long y = Character.digit(s.charAt(index), 16);
            x |= y;
            ++index;
        }
        return x;
    }

    public static boolean isHexString(String s) {
        if (s == null) {
            return false;
        }
        int length = s.length();
        int index = 0;
        while (index < length) {
            if (!Hex.isHexDigit(s.charAt(index))) {
                return false;
            }
            ++index;
        }
        return true;
    }

    public static boolean isHexDigit(char c) {
        return '0' <= c && c <= '9' || 'A' <= c && c <= 'F' || 'a' <= c && c <= 'f';
    }

    public static StringableFilter maskFilter(final long mask) {
        return new StringableFilter(){

            public Stringable filterStringable(Stringable obj) throws FilterException {
                long data;
                XNumber x;
                if (!(obj instanceof XNumber)) {
                    throw new FilterException(obj, "Filter must apply to objects that extend XNumber");
                }
                XNumber number = (XNumber)obj;
                if (obj instanceof XFloat) {
                    x = (XFloat)number;
                    data = Float.floatToRawIntBits(((XFloat)x).floatValue());
                    data &= 0xFFFFFFFFL;
                } else if (obj instanceof XDouble) {
                    x = (XDouble)number;
                    data = Double.doubleToRawLongBits(((XDouble)x).doubleValue());
                } else {
                    data = number.longValue();
                    if (obj instanceof XByte) {
                        data &= 0xFFL;
                    } else if (obj instanceof XShort) {
                        data &= 0xFFFFL;
                    } else if (obj instanceof XInt) {
                        data &= 0xFFFFFFFFL;
                    }
                }
                if ((data & mask) == 0L) {
                    return obj;
                }
                String s = Hex.longToHex(mask);
                throw new FilterException(obj, "Number must have zero bits where the mask " + s + " has one bits");
            }
        };
    }
}

