/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.util;

import java.awt.geom.Point2D;

public class FloatArray {
    private FloatArray() {
    }

    public static float[] deepclone(float[] data) {
        if (data == null) {
            return null;
        }
        return (float[])data.clone();
    }

    public static float[][] deepclone(float[][] data) {
        if (data == null) {
            return null;
        }
        int N = data.length;
        float[][] result = new float[N][];
        int i = 0;
        while (i < N) {
            result[i] = FloatArray.deepclone(data[i]);
            ++i;
        }
        return result;
    }

    public static float[] deepmerge(float[] array1, float[] array2) {
        if (array1 == null && array2 == null) {
            return null;
        }
        if (array1 == null) {
            return FloatArray.deepclone(array2);
        }
        if (array2 == null) {
            return FloatArray.deepclone(array1);
        }
        int M = array1.length;
        int N = array2.length;
        int S = M + N;
        float[] result = new float[S];
        int i = 0;
        while (i < S) {
            result[i] = i < M ? array1[i] : array2[i - M];
            ++i;
        }
        return result;
    }

    public static float[][] deepmerge(float[][] array1, float[][] array2) {
        if (array1 == null && array2 == null) {
            return null;
        }
        if (array1 == null) {
            return FloatArray.deepclone(array2);
        }
        if (array2 == null) {
            return FloatArray.deepclone(array1);
        }
        int M = array1.length;
        int N = array2.length;
        int S = Math.max(M, N);
        float[][] result = new float[S][];
        int i = 0;
        while (i < S) {
            float[] temp1 = i < M ? array1[i] : null;
            float[] temp2 = i < N ? array2[i] : null;
            result[i] = FloatArray.deepmerge(temp1, temp2);
            ++i;
        }
        return result;
    }

    public static boolean checkArray(float[][] array, int S) {
        if (array == null) {
            return false;
        }
        int length = array.length;
        int i = 0;
        while (i < length) {
            if (array[i] == null || array[i].length != S) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean checkArrayPair(float[][] array1, float[][] array2, int S) {
        return array1 != null && array2 != null && array1.length == array2.length && FloatArray.checkArray(array1, S) && FloatArray.checkArray(array2, S);
    }

    public static boolean equals(float[] array1, float[] array2) {
        if (array1 == array2) {
            return true;
        }
        if (array1 == null && array2 != null) {
            return false;
        }
        if (array1 != null && array2 == null) {
            return false;
        }
        int m = array1.length;
        int n = array2.length;
        if (m != n) {
            return false;
        }
        int i = 0;
        while (i < m) {
            if (array1[i] != array2[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean equals(float[][] array1, float[][] array2) {
        if (array1 == array2) {
            return true;
        }
        if (array1 == null && array2 != null) {
            return false;
        }
        if (array1 != null && array2 == null) {
            return false;
        }
        int m = array1.length;
        int n = array2.length;
        if (m != n) {
            return false;
        }
        int i = 0;
        while (i < m) {
            if (!FloatArray.equals(array1[i], array2[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static float[] fromPoint2D(Point2D point) {
        if (point == null) {
            return null;
        }
        float x = (float)point.getX();
        float y = (float)point.getY();
        return new float[]{x, y};
    }

    public static float[][] fromPoint2D(Point2D[] points) {
        if (points == null) {
            return null;
        }
        int N = points.length;
        float[][] result = new float[N][];
        int i = 0;
        while (i < N) {
            result[i] = FloatArray.fromPoint2D(points[i]);
            ++i;
        }
        return result;
    }

    public static Point2D toPoint2D(float[] array) {
        if (array == null || array.length != 2) {
            return null;
        }
        return new Point2D.Double(array[0], array[1]);
    }

    public static Point2D[] toPoint2D(float[][] array) {
        if (array == null) {
            return null;
        }
        int N = array.length;
        Point2D[] result = new Point2D[N];
        int i = 0;
        while (i < N) {
            result[i] = FloatArray.toPoint2D(array[i]);
            ++i;
        }
        return result;
    }
}

