/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.util;

import edu.neu.ccs.Strings;
import edu.neu.ccs.util.FileExistsException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Vector;

public class FileUtilities {
    private FileUtilities() {
    }

    public static void copyFile(String source, String destination, boolean overwrite) throws FileExistsException, IOException {
        FileUtilities.copyFile(new File(source), new File(destination), overwrite);
    }

    public static void copyFile(File source, File destination, boolean overwrite) throws FileExistsException, IOException {
        if (destination.exists() && !overwrite) {
            throw new FileExistsException(destination);
        }
        FileInputStream in = new FileInputStream(source);
        FileOutputStream out = new FileOutputStream(destination);
        byte[] buffer = new byte[4096];
        int i = in.read(buffer, 0, buffer.length);
        while (i > -1) {
            out.write(buffer, 0, i);
            i = in.read(buffer, 0, buffer.length);
        }
        in.close();
        out.close();
    }

    public static void createDirectory(File dir) throws FileExistsException, IOException {
        if (dir.exists()) {
            throw new FileExistsException(dir);
        }
        if (!dir.mkdirs()) {
            throw new IOException();
        }
    }

    public static void createDirectory(String dir) throws FileExistsException, IOException {
        FileUtilities.createDirectory(new File(dir));
    }

    public static void deleteFile(File f) throws FileNotFoundException, IOException {
        if (!f.exists()) {
            throw new FileNotFoundException();
        }
        if (!f.delete()) {
            throw new IOException();
        }
    }

    public static void deleteFile(String path) throws FileNotFoundException, IOException {
        FileUtilities.deleteFile(new File(path));
    }

    public static String[] readDirectory(File f) throws FileNotFoundException, IOException {
        if (!f.exists()) {
            throw new FileNotFoundException();
        }
        if (!f.isDirectory() || !f.canRead()) {
            throw new IOException();
        }
        return f.list();
    }

    public static String[] readDirectory(String path) throws FileNotFoundException, IOException {
        return FileUtilities.readDirectory(new File(path));
    }

    public static String[] filterFileList(String[] fileList, String[] extensionList) {
        if (fileList == null) {
            return null;
        }
        if (extensionList == null) {
            return fileList;
        }
        Vector<String> vector = new Vector<String>();
        int length1 = fileList.length;
        int length2 = extensionList.length;
        int j = 0;
        while (j < length2) {
            int i = 0;
            while (i < length1) {
                if (FileUtilities.matchesExtension(fileList[i], extensionList[j])) {
                    vector.add(fileList[i]);
                }
                ++i;
            }
            ++j;
        }
        return vector.toArray(new String[0]);
    }

    public static String[] filterFileList(String[] fileList, String extensionList) {
        if (extensionList == null) {
            return fileList;
        }
        return FileUtilities.filterFileList(fileList, Strings.splitCommaList(extensionList));
    }

    public static boolean matchesExtension(String fileName, String fileExtension) {
        if (fileName == null || fileExtension == null) {
            return false;
        }
        int size1 = fileName.length();
        int size2 = fileExtension.length();
        if (size2 == 0) {
            return false;
        }
        int offset = size1 - size2;
        return fileName.regionMatches(true, offset, fileExtension, 0, size2);
    }

    public static StringBuffer getFileContents(File f) throws FileNotFoundException, IOException {
        if (!f.exists()) {
            throw new FileNotFoundException();
        }
        if (!f.isFile() || !f.canRead()) {
            throw new IOException();
        }
        StringBuffer data = new StringBuffer((int)f.length());
        byte[] buffer = new byte[4096];
        FileInputStream stream = new FileInputStream(f);
        int in = stream.read(buffer);
        while (in > 0) {
            data.append(new String(buffer, 0, in));
            in = stream.read(buffer);
        }
        stream.close();
        return data;
    }

    public static String readFile(File f) throws FileNotFoundException, IOException {
        return FileUtilities.getFileContents(f).toString();
    }

    public static String readFile(String path) throws FileNotFoundException, IOException {
        return FileUtilities.getFileContents(new File(path)).toString();
    }

    public static void renameFile(File source, File destination) throws FileNotFoundException, FileExistsException, IOException {
        if (!source.exists()) {
            throw new FileNotFoundException();
        }
        if (destination.exists()) {
            throw new FileExistsException(destination);
        }
        if (!source.renameTo(destination)) {
            throw new IOException();
        }
    }

    public static void renameFile(String source, String destination) throws FileNotFoundException, FileExistsException, IOException {
        FileUtilities.renameFile(new File(source), new File(destination));
    }

    public static void writeFile(File f, String data, boolean overwrite) throws FileExistsException, IOException {
        if (f.exists() && !overwrite) {
            throw new FileExistsException(f);
        }
        FileOutputStream stream = new FileOutputStream(f);
        stream.write(data.getBytes());
        stream.close();
    }

    public static void writeFile(String destination, String data, boolean overwrite) throws FileExistsException, IOException {
        FileUtilities.writeFile(new File(destination), data, overwrite);
    }
}

