/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.util;

public class Conversions {
    private Conversions() {
    }

    public static short bytesToShortLoHi(byte[] b) {
        return Conversions.bytesToShortLoHi(b, 0);
    }

    public static short bytesToShortLoHi(byte[] b, int start) {
        int n = 2;
        if (b == null) {
            return 0;
        }
        int length = b.length;
        if (start < 0 || start >= length) {
            return 0;
        }
        int limit = Math.min(length - start, 2);
        short x = 0;
        int mask = 255;
        int i = 0;
        while (i < limit) {
            int y = b[start + i];
            y <<= 8 * i;
            x = (short)(x | (y &= mask));
            mask <<= 8;
            ++i;
        }
        return x;
    }

    public static short bytesToShortLoHi(byte b0, byte b1) {
        return Conversions.bytesToShortLoHi(new byte[]{b0, b1}, 0);
    }

    public static short bytesToShortHiLo(byte[] b) {
        return Conversions.bytesToShortHiLo(b, 0);
    }

    public static short bytesToShortHiLo(byte[] b, int start) {
        int n = 2;
        boolean bl = true;
        if (b == null) {
            return 0;
        }
        int length = b.length;
        if (start < 0 || start >= length) {
            return 0;
        }
        int limit = Math.min(length - start, 2);
        byte[] c = new byte[2];
        int i = 0;
        while (i < limit) {
            c[1 - i] = b[start + i];
            ++i;
        }
        return Conversions.bytesToShortLoHi(c, 0);
    }

    public static short bytesToShortHiLo(byte b0, byte b1) {
        return Conversions.bytesToShortLoHi(new byte[]{b1, b0}, 0);
    }

    public static byte[] shortToBytesLoHi(short s) {
        int n = 2;
        byte[] data = new byte[2];
        int t = s;
        int i = 0;
        while (i < 2) {
            data[i] = (byte)t;
            t >>= 8;
            ++i;
        }
        return data;
    }

    public static byte[] shortToBytesHiLo(short s) {
        int n = 2;
        boolean bl = true;
        byte[] data = new byte[2];
        int t = s;
        int i = 0;
        while (i < 2) {
            data[1 - i] = (byte)t;
            t >>= 8;
            ++i;
        }
        return data;
    }

    public static int bytesToIntLoHi(byte[] b) {
        return Conversions.bytesToIntLoHi(b, 0);
    }

    public static int bytesToIntLoHi(byte[] b, int start) {
        int n = 4;
        if (b == null) {
            return 0;
        }
        int length = b.length;
        if (start < 0 || start >= length) {
            return 0;
        }
        int limit = Math.min(length - start, 4);
        int x = 0;
        int mask = 255;
        int i = 0;
        while (i < limit) {
            int y = b[start + i];
            y <<= 8 * i;
            x |= (y &= mask);
            mask <<= 8;
            ++i;
        }
        return x;
    }

    public static int bytesToIntLoHi(byte b0, byte b1, byte b2, byte b3) {
        return Conversions.bytesToIntLoHi(new byte[]{b0, b1, b2, b3}, 0);
    }

    public static int bytesToIntHiLo(byte[] b) {
        return Conversions.bytesToIntHiLo(b, 0);
    }

    public static int bytesToIntHiLo(byte[] b, int start) {
        int n = 4;
        int n2 = 3;
        if (b == null) {
            return 0;
        }
        int length = b.length;
        if (start < 0 || start >= length) {
            return 0;
        }
        int limit = Math.min(length - start, 4);
        byte[] c = new byte[4];
        int i = 0;
        while (i < limit) {
            c[3 - i] = b[start + i];
            ++i;
        }
        return Conversions.bytesToIntLoHi(c, 0);
    }

    public static int bytesToIntHiLo(byte b0, byte b1, byte b2, byte b3) {
        return Conversions.bytesToIntLoHi(new byte[]{b3, b2, b1, b0}, 0);
    }

    public static byte[] intToBytesLoHi(int s) {
        int n = 4;
        byte[] data = new byte[4];
        int i = 0;
        while (i < 4) {
            data[i] = (byte)s;
            s >>= 8;
            ++i;
        }
        return data;
    }

    public static byte[] intToBytesHiLo(int s) {
        int n = 4;
        int n2 = 3;
        byte[] data = new byte[4];
        int i = 0;
        while (i < 4) {
            data[3 - i] = (byte)s;
            s >>= 8;
            ++i;
        }
        return data;
    }

    public static long bytesToLongLoHi(byte[] b) {
        return Conversions.bytesToLongLoHi(b, 0);
    }

    public static long bytesToLongLoHi(byte[] b, int start) {
        int n = 8;
        if (b == null) {
            return 0L;
        }
        int length = b.length;
        if (start < 0 || start >= length) {
            return 0L;
        }
        int limit = Math.min(length - start, 8);
        long x = 0L;
        long mask = 255L;
        int i = 0;
        while (i < limit) {
            long y = b[start + i];
            y <<= 8 * i;
            x |= (y &= mask);
            mask <<= 8;
            ++i;
        }
        return x;
    }

    public static long bytesToLongLoHi(byte b0, byte b1, byte b2, byte b3, byte b4, byte b5, byte b6, byte b7) {
        return Conversions.bytesToLongLoHi(new byte[]{b0, b1, b2, b3, b4, b5, b6, b7}, 0);
    }

    public static long bytesToLongHiLo(byte[] b) {
        return Conversions.bytesToLongHiLo(b, 0);
    }

    public static long bytesToLongHiLo(byte[] b, int start) {
        int n = 8;
        int n2 = 7;
        if (b == null) {
            return 0L;
        }
        int length = b.length;
        if (start < 0 || start >= length) {
            return 0L;
        }
        int limit = Math.min(length - start, 8);
        byte[] c = new byte[8];
        int i = 0;
        while (i < limit) {
            c[7 - i] = b[start + i];
            ++i;
        }
        return Conversions.bytesToLongLoHi(c, 0);
    }

    public static long bytesToLongHiLo(byte b0, byte b1, byte b2, byte b3, byte b4, byte b5, byte b6, byte b7) {
        return Conversions.bytesToLongLoHi(new byte[]{b7, b6, b5, b4, b3, b2, b1, b0}, 0);
    }

    public static byte[] longToBytesLoHi(long s) {
        int n = 8;
        byte[] data = new byte[8];
        int i = 0;
        while (i < 8) {
            data[i] = (byte)s;
            s >>= 8;
            ++i;
        }
        return data;
    }

    public static byte[] longToBytesHiLo(long s) {
        int n = 8;
        int n2 = 7;
        byte[] data = new byte[8];
        int i = 0;
        while (i < 8) {
            data[7 - i] = (byte)s;
            s >>= 8;
            ++i;
        }
        return data;
    }

    public static float shortToFloat(short s) {
        if (s == Short.MIN_VALUE) {
            return -1.0f;
        }
        return (float)s / 32767.0f;
    }

    public static float intToFloat(int s) {
        if (s == Integer.MIN_VALUE) {
            return -1.0f;
        }
        return (float)s / 2.1474836E9f;
    }

    public static float longToFloat(long s) {
        if (s == Long.MIN_VALUE) {
            return -1.0f;
        }
        return (float)s / 9.223372E18f;
    }

    public static short floatToShort(float x) {
        if (Float.isNaN(x)) {
            return 0;
        }
        if (x >= 1.0f) {
            return Short.MAX_VALUE;
        }
        if (x <= -1.0f) {
            return -32767;
        }
        double z = (double)(x * 32767.0f) + 0.5;
        return (short)Math.floor(z);
    }

    public static int floatToInt(float x) {
        if (Float.isNaN(x)) {
            return 0;
        }
        if (x >= 1.0f) {
            return Integer.MAX_VALUE;
        }
        if (x <= -1.0f) {
            return -2147483647;
        }
        double z = (double)(x * 2.1474836E9f) + 0.5;
        return (int)Math.floor(z);
    }

    public static long floatToLong(float x) {
        if (Float.isNaN(x)) {
            return 0L;
        }
        if (x >= 1.0f) {
            return Long.MAX_VALUE;
        }
        if (x <= -1.0f) {
            return -9223372036854775807L;
        }
        double z = (double)(x * 9.223372E18f) + 0.5;
        return (long)Math.floor(z);
    }

    public static double shortToDouble(short s) {
        if (s == Short.MIN_VALUE) {
            return -1.0;
        }
        return (double)s / 32767.0;
    }

    public static double intToDouble(int s) {
        if (s == Integer.MIN_VALUE) {
            return -1.0;
        }
        return (double)s / 2.147483647E9;
    }

    public static double longToDouble(long s) {
        if (s == Long.MIN_VALUE) {
            return -1.0;
        }
        return (double)s / 9.223372036854776E18;
    }

    public static short doubleToShort(double x) {
        if (Double.isNaN(x)) {
            return 0;
        }
        if (x >= 1.0) {
            return Short.MAX_VALUE;
        }
        if (x <= -1.0) {
            return -32767;
        }
        double z = x * 32767.0 + 0.5;
        return (short)Math.floor(z);
    }

    public static int doubleToInt(double x) {
        if (Double.isNaN(x)) {
            return 0;
        }
        if (x >= 1.0) {
            return Integer.MAX_VALUE;
        }
        if (x <= -1.0) {
            return -2147483647;
        }
        double z = x * 2.147483647E9 + 0.5;
        return (int)Math.floor(z);
    }

    public static long doubleToLong(double x) {
        if (Double.isNaN(x)) {
            return 0L;
        }
        if (x >= 1.0) {
            return Long.MAX_VALUE;
        }
        if (x <= -1.0) {
            return -9223372036854775807L;
        }
        double z = x * 9.223372036854776E18 + 0.5;
        return (long)Math.floor(z);
    }
}

